/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.help.ui.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.themes.IThemeManager;

public class UiLegendDialog
extends PopupDialog {
    public static final String TITLE = "Mylyn UI Overview";
    private FormToolkit toolkit;
    private ScrolledForm form;
    private TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    private IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();

    public UiLegendDialog(Shell parent) {
        super(parent, 16392, false, false, false, false, null, null);
    }

    protected Control createContents(Composite parent) {
        this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(16));
        return this.createDialogArea(parent);
    }

    public int open() {
        int open = super.open();
        this.getShell().setFocus();
        return open;
    }

    public boolean close() {
        if (this.toolkit != null && this.toolkit.getColors() != null) {
            this.toolkit.dispose();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText(TITLE);
        this.form.getToolBarManager().add((IAction)new CloseDialogAction());
        this.form.getToolBarManager().update(true);
        this.form.getBody().setLayout((Layout)new TableWrapLayout());
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.createTasksPrioritiesSection(this.form.getBody());
        this.createActivitySection(this.form.getBody());
        this.createContextSection(this.form.getBody());
        this.createSynchronizationSection(this.form.getBody());
        this.createConnectorsSection(this.form.getBody());
        this.createGettingStartedSection(this.form.getBody());
        return parent;
    }

    private void createTasksPrioritiesSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new TableWrapData(256));
        this.createTasksSection(composite);
        this.createPrioritiesSection(composite);
    }

    private void createTasksSection(Composite parent) {
        Section tasksSection = this.toolkit.createSection(parent, 256);
        tasksSection.setText("Tasks");
        tasksSection.setLayout((Layout)new TableWrapLayout());
        tasksSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite tasksClient = this.toolkit.createComposite((Composite)tasksSection);
        tasksClient.setLayout((Layout)layout);
        tasksClient.setLayoutData((Object)new TableWrapData(256));
        tasksSection.setClient((Control)tasksClient);
        Label imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        this.toolkit.createLabel(tasksClient, "Task");
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.CATEGORY));
        this.toolkit.createLabel(tasksClient, "Category");
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.QUERY));
        this.toolkit.createLabel(tasksClient, "Query");
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.CALENDAR));
        this.toolkit.createLabel(tasksClient, "Date range");
        imageLabel = this.toolkit.createLabel(tasksClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.BLANK));
        Hyperlink openView = this.toolkit.createHyperlink(tasksClient, "Open Task List...", 64);
        openView.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                UiLegendDialog.this.close();
                TaskListView.openInActivePerspective();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void createPrioritiesSection(Composite parent) {
        Section prioritiesSection = this.toolkit.createSection(parent, 256);
        prioritiesSection.setText("Priorities");
        prioritiesSection.setLayout((Layout)new TableWrapLayout());
        prioritiesSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite prioritiesClient = this.toolkit.createComposite((Composite)prioritiesSection);
        prioritiesClient.setLayout((Layout)layout);
        prioritiesClient.setLayoutData((Object)new TableWrapData(256));
        prioritiesSection.setClient((Control)prioritiesClient);
        Label imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_1));
        this.toolkit.createLabel(prioritiesClient, AbstractTask.PriorityLevel.P1.getDescription());
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_2));
        this.toolkit.createLabel(prioritiesClient, AbstractTask.PriorityLevel.P2.getDescription());
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_3));
        this.toolkit.createLabel(prioritiesClient, String.valueOf(AbstractTask.PriorityLevel.P3.getDescription()) + " (default)");
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_4));
        this.toolkit.createLabel(prioritiesClient, AbstractTask.PriorityLevel.P4.getDescription());
        imageLabel = this.toolkit.createLabel(prioritiesClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.PRIORITY_5));
        this.toolkit.createLabel(prioritiesClient, AbstractTask.PriorityLevel.P5.getDescription());
    }

    private void createActivitySection(Composite parent) {
        Section activitySection = this.toolkit.createSection(parent, 256);
        activitySection.setText("Task Activity");
        activitySection.setLayout((Layout)new TableWrapLayout());
        activitySection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite activityClient = this.toolkit.createComposite((Composite)activitySection);
        activityClient.setLayout((Layout)layout);
        activityClient.setLayoutData((Object)new TableWrapData(256));
        activitySection.setClient((Control)activityClient);
        Label imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelOverdue = this.toolkit.createLabel(activityClient, "Past scheduled date");
        labelOverdue.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.overdue"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelToday = this.toolkit.createLabel(activityClient, "Scheduled for today");
        labelToday.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.scheduled"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelCompleted = this.toolkit.createLabel(activityClient, "Completed");
        labelCompleted.setFont(TaskListColorsAndFonts.STRIKETHROUGH);
        labelCompleted.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        Label labelCompletedToday = this.toolkit.createLabel(activityClient, "Completed today");
        labelCompletedToday.setFont(TaskListColorsAndFonts.STRIKETHROUGH);
        labelCompletedToday.setForeground(this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.completed"));
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_HAS_DUE));
        this.toolkit.createLabel(activityClient, "Due date set");
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_OVER_DUE));
        this.toolkit.createLabel(activityClient, "Due date past");
        imageLabel = this.toolkit.createLabel(activityClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.BLANK));
        Hyperlink adjust = this.toolkit.createHyperlink(activityClient, "Adjust Colors and Fonts...", 64);
        adjust.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.ui.preferencePages.ColorsAndFonts", (String[])new String[]{"org.eclipse.ui.preferencePages.ColorsAndFonts"}, null);
                dlg.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private void createContextSection(Composite parent) {
        Section contextSection = this.toolkit.createSection(parent, 256);
        contextSection.setText("Task Context");
        contextSection.setLayout((Layout)new TableWrapLayout());
        contextSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 1;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite contextClient = this.toolkit.createComposite((Composite)contextSection);
        contextClient.setLayout((Layout)layout);
        contextClient.setLayoutData((Object)new TableWrapData(256));
        contextSection.setClient((Control)contextClient);
        Label imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.CONTEXT_FOCUS));
        this.toolkit.createLabel(contextClient, "Focus view on active task");
        imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK_INACTIVE));
        this.toolkit.createLabel(contextClient, "Inactive task with no context");
        imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK_INACTIVE_CONTEXT));
        this.toolkit.createLabel(contextClient, "Inactive task with context");
        imageLabel = this.toolkit.createLabel(contextClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.TASK_ACTIVE));
        this.toolkit.createLabel(contextClient, "Active task");
    }

    private void createSynchronizationSection(Composite parent) {
        Section synchroSection = this.toolkit.createSection(parent, 256);
        synchroSection.setText("Synchronization");
        synchroSection.setLayout((Layout)new TableWrapLayout());
        synchroSection.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 3;
        layout.topMargin = 1;
        layout.bottomMargin = 1;
        Composite synchroClient = this.toolkit.createComposite((Composite)synchroSection);
        synchroClient.setLayout((Layout)layout);
        synchroClient.setLayoutData((Object)new TableWrapData(256));
        synchroSection.setClient((Control)synchroClient);
        Label imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_INCOMMING_NEW));
        this.toolkit.createLabel(synchroClient, "New task, open to view");
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_INCOMMING));
        this.toolkit.createLabel(synchroClient, "Incoming changes, open to view");
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_OUTGOING));
        this.toolkit.createLabel(synchroClient, "Outgoing changes");
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_WARNING));
        this.toolkit.createLabel(synchroClient, "Synchronization failed, mouse over for details");
        imageLabel = this.toolkit.createLabel(synchroClient, "");
        imageLabel.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.OVERLAY_CONFLICT));
        this.toolkit.createLabel(synchroClient, "Conflicting changes, need to synchronize");
    }

    private void createConnectorsSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite composite = this.toolkit.createComposite(parent);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new TableWrapData(256));
        Collection connectors = TasksUiPlugin.getRepositoryManager().getRepositoryConnectors();
        for (AbstractRepositoryConnector connector : connectors) {
            Label imageLabel;
            List elements;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi((String)connector.getConnectorKind());
            if (connectorUi == null || (elements = connectorUi.getLegendItems()).isEmpty()) continue;
            Section connectorSection = this.toolkit.createSection(composite, 256);
            connectorSection.setLayout((Layout)new TableWrapLayout());
            connectorSection.setLayoutData((Object)new TableWrapData(256));
            String label = connector.getLabel();
            int parenIndex = label.indexOf(40);
            if (parenIndex != -1) {
                label = label.substring(0, parenIndex);
            }
            connectorSection.setText(label);
            TableWrapLayout clientLayout = new TableWrapLayout();
            clientLayout.numColumns = 2;
            clientLayout.makeColumnsEqualWidth = false;
            clientLayout.verticalSpacing = 1;
            clientLayout.topMargin = 1;
            clientLayout.bottomMargin = 1;
            Composite connectorClient = this.toolkit.createComposite((Composite)connectorSection);
            connectorClient.setLayout((Layout)clientLayout);
            connectorClient.setLayoutData((Object)new TableWrapData(256));
            connectorSection.setClient((Control)connectorClient);
            for (AbstractTaskContainer taskListElement : elements) {
                imageLabel = this.toolkit.createLabel(connectorClient, "");
                imageLabel.setImage(this.labelProvider.getImage((Object)taskListElement));
                this.toolkit.createLabel(connectorClient, taskListElement.getSummary());
            }
            if (elements.size() >= 4) continue;
            imageLabel = this.toolkit.createLabel(connectorClient, "");
            this.toolkit.createLabel(connectorClient, "");
        }
    }

    private void createGettingStartedSection(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        Composite hyperlinkClient = this.toolkit.createComposite(parent);
        hyperlinkClient.setLayout((Layout)layout);
        hyperlinkClient.setLayoutData((Object)new TableWrapData(256));
        Hyperlink gettingStartedLink = this.toolkit.createHyperlink(hyperlinkClient, "Also see the Getting Started documentation online", 64);
        gettingStartedLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                UiLegendDialog.this.close();
                TasksUiUtil.openUrl((String)"http://www.eclipse.org/mylyn/start/", (boolean)false);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
    }

    private class CloseDialogAction
    extends Action {
        private CloseDialogAction() {
            this.setImageDescriptor(TasksUiImages.NOTIFICATION_CLOSE);
            this.setText("Close Dialog");
        }

        public void run() {
            UiLegendDialog.this.close();
        }
    }
}

