/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class BugzillaClientManager
implements ITaskRepositoryListener {
    private Map<String, BugzillaClient> clientByUrl = new HashMap<String, BugzillaClient>();

    public synchronized BugzillaClient getClient(TaskRepository taskRepository) throws MalformedURLException {
        BugzillaClient client = this.clientByUrl.get(taskRepository.getUrl());
        if (client == null) {
            String htUser = taskRepository.getHttpUser() != null ? taskRepository.getHttpUser() : "";
            String htPass = taskRepository.getHttpPassword() != null ? taskRepository.getHttpPassword() : "";
            String language = taskRepository.getProperty("bugzilla.languageSetting");
            if (language == null || language.equals("")) {
                language = "en (default)";
            }
            BugzillaLanguageSettings languageSettings = BugzillaCorePlugin.getDefault().getLanguageSetting(language);
            client = BugzillaClientFactory.createClient(taskRepository.getUrl(), taskRepository.getUserName(), taskRepository.getPassword(), htUser, htPass, taskRepository.getProxy(), taskRepository.getCharacterEncoding(), taskRepository.getProperties(), languageSettings);
            this.clientByUrl.put(taskRepository.getUrl(), client);
        }
        return client;
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        this.clientByUrl.remove(repository.getUrl());
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.clientByUrl.remove(repository.getUrl());
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.clientByUrl.remove(repository.getUrl());
    }
}

