/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaCorePlugin
extends Plugin {
    private static final String ERROR_DELETING_CONFIGURATION = "Error removing corrupt repository configuration file.";
    public static final String REPOSITORY_KIND = "bugzilla";
    public static final String PLUGIN_ID = "org.eclipse.mylyn.bugzilla";
    private static BugzillaCorePlugin INSTANCE;
    private static boolean cacheFileRead;
    private static File repositoryConfigurationFile;
    private static BugzillaRepositoryConnector connector;
    private static final String OPTION_ALL = "All";
    private Map<String, String> java2buzillaPlatformMap = new HashMap<String, String>();
    private static Map<String, RepositoryConfiguration> repositoryConfigurations;

    static {
        cacheFileRead = false;
        repositoryConfigurationFile = null;
        repositoryConfigurations = new HashMap<String, RepositoryConfiguration>();
    }

    public BugzillaCorePlugin() {
        this.java2buzillaPlatformMap.put("x86", "PC");
        this.java2buzillaPlatformMap.put("x86_64", "PC");
        this.java2buzillaPlatformMap.put("ia64", "PC");
        this.java2buzillaPlatformMap.put("ia64_32", "PC");
        this.java2buzillaPlatformMap.put("sparc", "Sun");
        this.java2buzillaPlatformMap.put("ppc", "Power PC");
    }

    public static BugzillaCorePlugin getDefault() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (!repositoryConfigurations.isEmpty()) {
            BugzillaCorePlugin.writeRepositoryConfigFile();
        }
        INSTANCE = null;
        super.stop(context);
    }

    static void setConnector(BugzillaRepositoryConnector theConnector) {
        connector = theConnector;
    }

    public static Map<String, RepositoryConfiguration> getConfigurations() {
        if (!cacheFileRead) {
            BugzillaCorePlugin.readRepositoryConfigurationFile();
            cacheFileRead = true;
        }
        return repositoryConfigurations;
    }

    public static void setConfigurationCacheFile(File file) {
        repositoryConfigurationFile = file;
    }

    public static RepositoryConfiguration getRepositoryConfiguration(String repositoryUrl) {
        return repositoryConfigurations.get(repositoryUrl);
    }

    public static RepositoryConfiguration getRepositoryConfiguration(TaskRepository repository, boolean forceRefresh) throws CoreException {
        try {
            BugzillaClient client;
            RepositoryConfiguration config;
            if (!cacheFileRead) {
                BugzillaCorePlugin.readRepositoryConfigurationFile();
                cacheFileRead = true;
            }
            if ((repositoryConfigurations.get(repository.getUrl()) == null || forceRefresh) && (config = (client = connector.getClientManager().getClient(repository)).getRepositoryConfiguration()) != null) {
                BugzillaCorePlugin.addRepositoryConfiguration(config);
            }
            return repositoryConfigurations.get(repository.getUrl());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, 1, "Error updating attributes.\n\n" + e.getMessage(), (Throwable)e));
        }
    }

    public static void addRepositoryConfiguration(RepositoryConfiguration config) {
        repositoryConfigurations.remove(config.getRepositoryUrl());
        repositoryConfigurations.put(config.getRepositoryUrl(), config);
    }

    public static void removeConfiguration(RepositoryConfiguration config) {
        repositoryConfigurations.remove(config.getRepositoryUrl());
    }

    public static void readRepositoryConfigurationFile() {
        block21: {
            if (repositoryConfigurationFile == null || !repositoryConfigurationFile.exists()) {
                return;
            }
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(repositoryConfigurationFile));
                    int size = in.readInt();
                    int nX = 0;
                    while (nX < size) {
                        RepositoryConfiguration item = (RepositoryConfiguration)in.readObject();
                        if (item != null) {
                            repositoryConfigurations.put(item.getRepositoryUrl(), item);
                        }
                        ++nX;
                    }
                }
                catch (Exception e) {
                    BugzillaCorePlugin.log(e);
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (repositoryConfigurationFile != null && repositoryConfigurationFile.exists() && !repositoryConfigurationFile.delete()) {
                            BugzillaCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, ERROR_DELETING_CONFIGURATION, (Throwable)e));
                        }
                    }
                    catch (Exception exception) {
                        BugzillaCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, ERROR_DELETING_CONFIGURATION, (Throwable)e));
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeRepositoryConfigFile() {
        block16: {
            if (repositoryConfigurationFile != null) {
                ObjectOutputStream out = null;
                try {
                    try {
                        out = new ObjectOutputStream(new FileOutputStream(repositoryConfigurationFile));
                        out.writeInt(repositoryConfigurations.size());
                        for (String key : repositoryConfigurations.keySet()) {
                            RepositoryConfiguration item = repositoryConfigurations.get(key);
                            if (item == null) continue;
                            out.writeObject(item);
                        }
                    }
                    catch (IOException e) {
                        BugzillaCorePlugin.log(e);
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void log(IStatus status) {
        BugzillaCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Exception e) {
        String message = e.getMessage();
        if (e.getMessage() == null) {
            message = e.getClass().toString();
        }
        BugzillaCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, message, (Throwable)e));
    }

    protected IPath getCachedBugReportPath() {
        IPath stateLocation = Platform.getStateLocation((Bundle)BugzillaCorePlugin.getDefault().getBundle());
        IPath bugFile = stateLocation.append("bugReports");
        return bugFile;
    }

    public void setPlatformDefaultsOrGuess(TaskRepository repository, RepositoryTaskData newBugModel) {
        String platform = repository.getProperty("bugzilla.default.platform");
        String os = repository.getProperty("bugzilla.default.os");
        if (os != null && platform != null) {
            RepositoryTaskAttribute opSysAttribute = newBugModel.getAttribute(BugzillaReportElement.OP_SYS.getKeyString());
            RepositoryTaskAttribute platformAttribute = newBugModel.getAttribute(BugzillaReportElement.REP_PLATFORM.getKeyString());
            opSysAttribute.setValue(os);
            platformAttribute.setValue(platform);
            return;
        }
        this.setPlatformOptions(newBugModel);
    }

    public void setPlatformOptions(RepositoryTaskData newBugModel) {
        try {
            RepositoryTaskAttribute opSysAttribute = newBugModel.getAttribute(BugzillaReportElement.OP_SYS.getKeyString());
            RepositoryTaskAttribute platformAttribute = newBugModel.getAttribute(BugzillaReportElement.REP_PLATFORM.getKeyString());
            String OS = Platform.getOS();
            String platform = Platform.getOSArch();
            String bugzillaOS = null;
            String bugzillaPlatform = null;
            bugzillaOS = String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version");
            if (opSysAttribute != null) {
                while (bugzillaOS != null && opSysAttribute.getOptionParameter(bugzillaOS) == null) {
                    int spaceindex;
                    int dotindex = bugzillaOS.lastIndexOf(46);
                    bugzillaOS = dotindex > 0 ? bugzillaOS.substring(0, dotindex) : ((spaceindex = bugzillaOS.lastIndexOf(32)) > 0 ? bugzillaOS.substring(0, spaceindex) : null);
                }
            } else {
                bugzillaOS = null;
            }
            if (platform != null && this.java2buzillaPlatformMap.containsKey(platform)) {
                bugzillaPlatform = this.java2buzillaPlatformMap.get(platform);
                if (bugzillaPlatform != null && (bugzillaPlatform.compareTo("Power") == 0 || bugzillaPlatform.compareTo("PC") == 0) && OS != null && OS.compareTo("macosx") == 0) {
                    bugzillaPlatform = "Macintosh";
                } else if (platformAttribute != null && platformAttribute.getOptionParameter(bugzillaPlatform) == null) {
                    bugzillaPlatform = null;
                }
            }
            if (bugzillaOS != null && opSysAttribute != null) {
                opSysAttribute.setValue(bugzillaOS);
            } else if (opSysAttribute != null && opSysAttribute.getOptionParameter(OPTION_ALL) != null) {
                opSysAttribute.setValue(OPTION_ALL);
            }
            if (bugzillaPlatform != null && platformAttribute != null) {
                platformAttribute.setValue(bugzillaPlatform);
            } else if (opSysAttribute != null && platformAttribute != null && platformAttribute.getOptionParameter(OPTION_ALL) != null) {
                opSysAttribute.setValue(OPTION_ALL);
            }
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"could not set platform options", (boolean)false);
        }
    }

    public Set<BugzillaLanguageSettings> getLanguageSettings() {
        return connector.getLanguageSettings();
    }

    public BugzillaLanguageSettings getLanguageSetting(String language) {
        return connector.getLanguageSetting(language);
    }
}

