/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttachmentHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.UnrecognizedReponseException;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.QueryHitCollector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String BUG_ID = "&bug_id=";
    private static final String CHANGED_BUGS_CGI_ENDDATE = "&chfieldto=Now";
    private static final String CHANGED_BUGS_CGI_QUERY = "/buglist.cgi?query_format=advanced&chfieldfrom=";
    private static final String CLIENT_LABEL = "Bugzilla (supports uncustomized 2.18-3.0)";
    private static final String COMMENT_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String DEADLINE_FORMAT = "yyyy-MM-dd";
    private BugzillaAttachmentHandler attachmentHandler;
    private BugzillaTaskDataHandler taskDataHandler;
    private BugzillaClientManager clientManager;
    private Set<BugzillaLanguageSettings> languages = new LinkedHashSet<BugzillaLanguageSettings>();

    public void init(TaskList taskList) {
        super.init(taskList);
        this.taskDataHandler = new BugzillaTaskDataHandler(this);
        this.attachmentHandler = new BugzillaAttachmentHandler(this);
        BugzillaCorePlugin.setConnector(this);
        BugzillaLanguageSettings enSetting = new BugzillaLanguageSettings("en (default)");
        enSetting.addLanguageAttribute("error_login", "Login");
        enSetting.addLanguageAttribute("error_login", "log in");
        enSetting.addLanguageAttribute("error_login", "check e-mail");
        enSetting.addLanguageAttribute("error_login", "Invalid Username Or Password");
        enSetting.addLanguageAttribute("error_collision", "Mid-air collision!");
        enSetting.addLanguageAttribute("error_comment_required", "Comment Required");
        enSetting.addLanguageAttribute("error_logged_out", "logged out");
        enSetting.addLanguageAttribute("bad_login", "Login");
        enSetting.addLanguageAttribute("bad_login", "log in");
        enSetting.addLanguageAttribute("bad_login", "check e-mail");
        enSetting.addLanguageAttribute("bad_login", "Invalid Username Or Password");
        enSetting.addLanguageAttribute("bad_login", "error");
        enSetting.addLanguageAttribute("processed", "processed");
        enSetting.addLanguageAttribute("changes_submitted", "Changes submitted");
        this.languages.add(enSetting);
    }

    public String getLabel() {
        return CLIENT_LABEL;
    }

    public AbstractAttachmentHandler getAttachmentHandler() {
        return this.attachmentHandler;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public String getConnectorKind() {
        return "bugzilla";
    }

    public AbstractTask createTask(String repositoryUrl, String id, String summary) {
        BugzillaTask task = new BugzillaTask(repositoryUrl, id, summary);
        task.setCreationDate(new Date());
        return task;
    }

    public void updateTaskFromTaskData(TaskRepository repository, AbstractTask repositoryTask, RepositoryTaskData taskData) {
        BugzillaTask bugzillaTask = (BugzillaTask)repositoryTask;
        if (taskData != null) {
            String severity;
            Date dateCreated;
            String createdString;
            String summary = taskData.getSummary();
            bugzillaTask.setSummary(summary);
            String owner = taskData.getAssignedTo();
            if (owner != null && !owner.equals("")) {
                bugzillaTask.setOwner(owner);
            }
            if ((createdString = taskData.getCreated()) != null && createdString.length() > 0 && (dateCreated = taskData.getAttributeFactory().getDateForAttributeType("task.common.date.created", taskData.getCreated())) != null) {
                bugzillaTask.setCreationDate(dateCreated);
            }
            boolean isComplete = false;
            if (taskData.getStatus() != null) {
                isComplete = taskData.getStatus().equals("RESOLVED") || taskData.getStatus().equals("CLOSED") || taskData.getStatus().equals("VERIFIED");
            }
            bugzillaTask.setCompleted(isComplete);
            if (isComplete) {
                Date completionDate = null;
                try {
                    List taskComments = taskData.getComments();
                    if (taskComments != null && !taskComments.isEmpty()) {
                        completionDate = new SimpleDateFormat(COMMENT_FORMAT).parse(((TaskComment)taskComments.get(taskComments.size() - 1)).getCreated());
                    }
                }
                catch (Exception exception) {}
                if (bugzillaTask.getCompletionDate() != null) {
                    // empty if block
                }
                bugzillaTask.setCompletionDate(completionDate);
            }
            String priority = AbstractTask.PriorityLevel.getDefault().toString();
            if (taskData.getAttribute("task.common.priority") != null) {
                priority = taskData.getAttribute("task.common.priority").getValue();
            }
            bugzillaTask.setPriority(priority);
            String url = this.getTaskUrl(repository.getUrl(), taskData.getId());
            if (url != null) {
                bugzillaTask.setUrl(url);
            }
            if (taskData.getProduct() != null) {
                bugzillaTask.setProduct(taskData.getProduct());
            }
            if ((severity = taskData.getAttributeValue(BugzillaReportElement.BUG_SEVERITY.getKeyString())) != null && !severity.equals("")) {
                bugzillaTask.setSeverity(severity);
            }
            if (taskData.getAttribute(BugzillaReportElement.ESTIMATED_TIME.getKeyString()) != null) {
                Date dueDate = null;
                try {
                    String dueStr = taskData.getAttributeValue(BugzillaReportElement.DEADLINE.getKeyString());
                    if (dueStr != null) {
                        dueDate = new SimpleDateFormat(DEADLINE_FORMAT).parse(dueStr);
                    }
                }
                catch (Exception exception) {}
                bugzillaTask.setDueDate(dueDate);
            }
        }
    }

    public boolean updateTaskFromQueryHit(TaskRepository repository, AbstractTask existingTask, AbstractTask newTask) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean markStaleTasks(TaskRepository repository, Set<AbstractTask> tasks, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Checking for changed tasks", -1);
            if (repository.getSynchronizationTimeStamp() == null) {
                for (AbstractTask task : tasks) {
                    task.setStale(true);
                }
                return true;
            }
            try {
                dateString = repository.getSynchronizationTimeStamp();
                if (dateString == null) {
                    dateString = "";
                }
                urlQueryBase = String.valueOf(repository.getUrl()) + "/buglist.cgi?query_format=advanced&chfieldfrom=" + URLEncoder.encode(dateString, repository.getCharacterEncoding()) + "&chfieldto=Now";
                urlQueryString = String.valueOf(urlQueryBase) + "&bug_id=";
                changedTasks = new HashSet<AbstractTask>();
                queryCounter = -1;
                itr = tasks.iterator();
                while (itr.hasNext()) {
                    ++queryCounter;
                    task = itr.next();
                    newurlQueryString = URLEncoder.encode(String.valueOf(task.getTaskId()) + ",", repository.getCharacterEncoding());
                    if (urlQueryString.length() + newurlQueryString.length() + "&ctype=rdf".length() > 2000) {
                        this.queryForChanged(repository, changedTasks, urlQueryString);
                        queryCounter = 0;
                        urlQueryString = String.valueOf(urlQueryBase) + "&bug_id=";
                    }
                    urlQueryString = String.valueOf(urlQueryString) + newurlQueryString;
                    if (itr.hasNext()) continue;
                    this.queryForChanged(repository, changedTasks, urlQueryString);
                }
                var11_14 = tasks.iterator();
                while (true) {
                    if (!var11_14.hasNext()) ** continue;
                    task = var11_14.next();
                    if (!changedTasks.contains(task)) ** continue;
                    task.setStale(true);
                }
            }
            catch (UnsupportedEncodingException e) {
                StatusHandler.fail((Throwable)e, (String)("Repository configured with unsupported encoding: " + repository.getCharacterEncoding() + "\n\n Unable to determine changed tasks."), (boolean)true);
                return false;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void queryForChanged(TaskRepository repository, Set<AbstractTask> changedTasks, String urlQueryString) throws UnsupportedEncodingException, CoreException {
        QueryHitCollector collector = new QueryHitCollector(new ITaskFactory(){

            public AbstractTask createTask(RepositoryTaskData taskData, IProgressMonitor monitor) {
                return BugzillaRepositoryConnector.this.taskList.getTask(taskData.getRepositoryUrl(), taskData.getId());
            }
        });
        BugzillaRepositoryQuery query = new BugzillaRepositoryQuery(repository.getUrl(), urlQueryString, "");
        this.performQuery(query, repository, (IProgressMonitor)new NullProgressMonitor(), (ITaskCollector)collector);
        changedTasks.addAll(collector.getTasks());
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(AbstractRepositoryQuery query, TaskRepository repository, IProgressMonitor monitor, ITaskCollector resultCollector) {
        try {
            monitor.beginTask("Running query", -1);
            BugzillaClient client = this.getClientManager().getClient(repository);
            boolean hitsReceived = client.getSearchHits(query, resultCollector);
            if (!hitsReceived) {
                client.logout();
                client.getSearchHits(query, resultCollector);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (UnrecognizedReponseException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 1, "Unrecognized response from server", (Throwable)e);
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 4, "Check repository configuration: " + e.getMessage(), (Throwable)e);
            return status;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("/show_bug.cgi?id=");
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        int index;
        if (url == null) {
            return null;
        }
        int anchorIndex = url.lastIndexOf("#");
        String bugUrl = url;
        if (anchorIndex != -1) {
            bugUrl = url.substring(0, anchorIndex);
        }
        return (index = bugUrl.indexOf("/show_bug.cgi?id=")) == -1 ? null : bugUrl.substring(index + "/show_bug.cgi?id=".length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        try {
            return BugzillaClient.getBugUrlWithoutLogin(repositoryUrl, taskId);
        }
        catch (Exception ex) {
            StatusHandler.fail((Throwable)ex, (String)("Error constructing task url for " + repositoryUrl + "  id:" + taskId), (boolean)false);
            return null;
        }
    }

    public void updateTaskFromRepository(TaskRepository repository, AbstractTask repositoryTask, IProgressMonitor monitor) {
    }

    public String getTaskIdPrefix() {
        return "bug";
    }

    public BugzillaClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new BugzillaClientManager();
        }
        return this.clientManager;
    }

    public void updateAttributes(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (repository != null) {
            BugzillaCorePlugin.getRepositoryConfiguration(repository, true);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository) throws CoreException {
        if (super.isRepositoryConfigurationStale(repository)) {
            boolean result = true;
            try {
                String timestamp;
                BugzillaClient client = this.getClientManager().getClient(repository);
                if (client != null && (timestamp = client.getConfigurationTimestamp()) != null) {
                    String oldTimestamp = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp");
                    if (oldTimestamp != null) {
                        result = !timestamp.equals(oldTimestamp);
                    }
                    repository.setProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp", timestamp);
                }
            }
            catch (MalformedURLException e) {
                StatusHandler.fail((Throwable)e, (String)("Error retrieving configuration timestamp for " + repository.getUrl()), (boolean)false);
            }
            return result;
        }
        return false;
    }

    public void updateAttributeOptions(TaskRepository taskRepository, RepositoryTaskData existingReport) throws CoreException {
        String product = existingReport.getAttributeValue(BugzillaReportElement.PRODUCT.getKeyString());
        for (RepositoryTaskAttribute attribute : existingReport.getAttributes()) {
            BugzillaReportElement element = BugzillaReportElement.valueOf(attribute.getId().trim().toUpperCase(Locale.ENGLISH));
            attribute.clearOptions();
            List<String> optionValues = BugzillaCorePlugin.getRepositoryConfiguration(taskRepository, false).getOptionValues(element, product);
            if (element != BugzillaReportElement.OP_SYS && element != BugzillaReportElement.BUG_SEVERITY && element != BugzillaReportElement.PRIORITY && element != BugzillaReportElement.BUG_STATUS) {
                Collections.sort(optionValues);
            }
            if (element == BugzillaReportElement.TARGET_MILESTONE && optionValues.isEmpty()) {
                existingReport.removeAttribute((Object)BugzillaReportElement.TARGET_MILESTONE);
                continue;
            }
            attribute.clearOptions();
            for (String option : optionValues) {
                attribute.addOption(option, option);
            }
        }
    }

    public static void setupNewBugAttributes(TaskRepository taskRepository, RepositoryTaskData newTaskData) throws CoreException {
        String product = newTaskData.getProduct();
        newTaskData.removeAllAttributes();
        RepositoryConfiguration repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration(taskRepository, false);
        RepositoryTaskAttribute a = BugzillaClient.makeNewAttribute(BugzillaReportElement.PRODUCT);
        List<String> optionValues = repositoryConfiguration.getProducts();
        Collections.sort(optionValues);
        a.setValue(product);
        a.setReadOnly(true);
        newTaskData.addAttribute(BugzillaReportElement.PRODUCT.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BUG_STATUS);
        optionValues = repositoryConfiguration.getStatusValues();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        a.setValue("NEW");
        newTaskData.addAttribute(BugzillaReportElement.BUG_STATUS.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.SHORT_DESC);
        newTaskData.addAttribute(BugzillaReportElement.SHORT_DESC.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.VERSION);
        optionValues = repositoryConfiguration.getVersions(newTaskData.getProduct());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(optionValues.size() - 1));
        }
        newTaskData.addAttribute(BugzillaReportElement.VERSION.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.COMPONENT);
        optionValues = repositoryConfiguration.getComponents(newTaskData.getProduct());
        Collections.sort(optionValues);
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() == 1) {
            a.setValue(optionValues.get(0));
        }
        newTaskData.addAttribute(BugzillaReportElement.COMPONENT.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.REP_PLATFORM);
        optionValues = repositoryConfiguration.getPlatforms();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(0));
        }
        newTaskData.addAttribute(BugzillaReportElement.REP_PLATFORM.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.OP_SYS);
        optionValues = repositoryConfiguration.getOSs();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(0));
        }
        newTaskData.addAttribute(BugzillaReportElement.OP_SYS.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.PRIORITY);
        optionValues = repositoryConfiguration.getPriorities();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(optionValues.size() / 2));
        }
        newTaskData.addAttribute(BugzillaReportElement.PRIORITY.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BUG_SEVERITY);
        optionValues = repositoryConfiguration.getSeverities();
        for (String option : optionValues) {
            a.addOption(option, option);
        }
        if (optionValues.size() > 0) {
            a.setValue(optionValues.get(optionValues.size() / 2));
        }
        newTaskData.addAttribute(BugzillaReportElement.BUG_SEVERITY.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.ASSIGNED_TO);
        a.setValue("");
        a.setReadOnly(false);
        newTaskData.addAttribute(BugzillaReportElement.ASSIGNED_TO.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BUG_FILE_LOC);
        a.setValue("http://");
        a.setHidden(false);
        newTaskData.addAttribute(BugzillaReportElement.BUG_FILE_LOC.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.DEPENDSON);
        a.setValue("");
        a.setReadOnly(false);
        newTaskData.addAttribute(BugzillaReportElement.DEPENDSON.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.BLOCKED);
        a.setValue("");
        a.setReadOnly(false);
        newTaskData.addAttribute(BugzillaReportElement.BLOCKED.getKeyString(), a);
        a = BugzillaClient.makeNewAttribute(BugzillaReportElement.NEWCC);
        a.setValue("");
        a.setReadOnly(false);
        newTaskData.addAttribute(BugzillaReportElement.NEWCC.getKeyString(), a);
    }

    public static int getBugId(String taskId) throws CoreException {
        try {
            return Integer.parseInt(taskId);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 0, "Invalid bug id: " + taskId, (Throwable)e));
        }
    }

    public void addLanguageSetting(BugzillaLanguageSettings language) {
        if (!this.languages.contains(language)) {
            this.languages.add(language);
        }
    }

    public Set<BugzillaLanguageSettings> getLanguageSettings() {
        return this.languages;
    }

    public BugzillaLanguageSettings getLanguageSetting(String label) {
        for (BugzillaLanguageSettings language : this.getLanguageSettings()) {
            if (!language.getLanguageName().equals(label)) continue;
            return language;
        }
        return BugzillaCorePlugin.getDefault().getLanguageSetting("en (default)");
    }
}

