/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.web.core.HtmlStreamTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxMultiBugReportContentHandler
extends DefaultHandler {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String COMMENT_ATTACHMENT_STRING = "Created an attachment (id=";
    private StringBuffer characters;
    private TaskComment taskComment;
    private Map<String, TaskComment> attachIdToComment = new HashMap<String, TaskComment>();
    private int commentNum = 0;
    private RepositoryAttachment attachment;
    private Map<String, RepositoryTaskData> taskDataMap;
    private RepositoryTaskData repositoryTaskData;
    private String errorMessage = null;
    private AbstractAttributeFactory attributeFactory;

    public SaxMultiBugReportContentHandler(AbstractAttributeFactory factory, Map<String, RepositoryTaskData> taskDataMap) {
        this.attributeFactory = factory;
        this.taskDataMap = taskDataMap;
    }

    public boolean errorOccurred() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
        BugzillaReportElement tag = BugzillaReportElement.UNKNOWN;
        try {
            tag = BugzillaReportElement.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
        switch (tag) {
            case BUGZILLA: {
                break;
            }
            case BUG: {
                if (attributes != null && attributes.getValue("error") != null) {
                    this.errorMessage = attributes.getValue("error");
                }
                this.attachIdToComment = new HashMap<String, TaskComment>();
                this.commentNum = 0;
                this.taskComment = null;
                break;
            }
            case LONG_DESC: {
                this.taskComment = new TaskComment(this.attributeFactory, this.commentNum++);
                break;
            }
            case WHO: {
                String name;
                if (this.taskComment == null || attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                this.taskComment.setAttributeValue(BugzillaReportElement.WHO_NAME.getKeyString(), name);
                break;
            }
            case REPORTER: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                RepositoryTaskAttribute attr = this.attributeFactory.createAttribute(BugzillaReportElement.REPORTER_NAME.getKeyString());
                attr.setValue(name);
                this.repositoryTaskData.addAttribute(BugzillaReportElement.REPORTER_NAME.getKeyString(), attr);
                break;
            }
            case ASSIGNED_TO: {
                String name;
                if (attributes == null || attributes.getLength() <= 0 || (name = attributes.getValue(ATTRIBUTE_NAME)) == null) break;
                RepositoryTaskAttribute attr = this.attributeFactory.createAttribute(BugzillaReportElement.ASSIGNED_TO_NAME.getKeyString());
                attr.setValue(name);
                this.repositoryTaskData.addAttribute(BugzillaReportElement.ASSIGNED_TO_NAME.getKeyString(), attr);
                break;
            }
            case ATTACHMENT: {
                this.attachment = new RepositoryAttachment(this.attributeFactory);
                if (attributes == null) break;
                if ("1".equals(attributes.getValue(BugzillaReportElement.IS_OBSOLETE.getKeyString()))) {
                    this.attachment.addAttribute(BugzillaReportElement.IS_OBSOLETE.getKeyString(), this.attributeFactory.createAttribute(BugzillaReportElement.IS_OBSOLETE.getKeyString()));
                    this.attachment.setObsolete(true);
                }
                if (!"1".equals(attributes.getValue(BugzillaReportElement.IS_PATCH.getKeyString()))) break;
                this.attachment.setPatch(true);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String parsedText = HtmlStreamTokenizer.unescape((String)this.characters.toString());
        BugzillaReportElement tag = BugzillaReportElement.UNKNOWN;
        try {
            tag = BugzillaReportElement.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
        switch (tag) {
            case BUG_ID: {
                RepositoryTaskAttribute attr;
                try {
                    this.repositoryTaskData = this.taskDataMap.get(parsedText.trim());
                    if (this.repositoryTaskData == null) {
                        this.errorMessage = String.valueOf(parsedText) + " id not found.";
                    }
                }
                catch (Exception exception) {
                    this.errorMessage = "Bug id from server did not match requested id.";
                }
                if ((attr = this.repositoryTaskData.getAttribute(tag.getKeyString())) == null) {
                    attr = this.attributeFactory.createAttribute(tag.getKeyString());
                    this.repositoryTaskData.addAttribute(tag.getKeyString(), attr);
                }
                attr.setValue(parsedText);
                break;
            }
            case WHO: {
                if (this.taskComment == null) break;
                RepositoryTaskAttribute attr = this.attributeFactory.createAttribute(tag.getKeyString());
                attr.setValue(parsedText);
                this.taskComment.addAttribute(tag.getKeyString(), attr);
                break;
            }
            case BUG_WHEN: {
                if (this.taskComment == null) break;
                RepositoryTaskAttribute attr = this.attributeFactory.createAttribute(tag.getKeyString());
                attr.setValue(parsedText);
                this.taskComment.addAttribute(tag.getKeyString(), attr);
                break;
            }
            case THETEXT: {
                if (this.taskComment == null) break;
                RepositoryTaskAttribute attr = this.attributeFactory.createAttribute(tag.getKeyString());
                attr.setValue(parsedText);
                this.taskComment.addAttribute(tag.getKeyString(), attr);
                this.parseAttachment(this.taskComment, parsedText);
                break;
            }
            case LONG_DESC: {
                if (this.taskComment == null) break;
                if (this.taskComment.getNumber() == 0) {
                    this.repositoryTaskData.setAttributeValue("task.common.description", this.taskComment.getText());
                    break;
                }
                this.repositoryTaskData.addComment(this.taskComment);
                break;
            }
            case ATTACHID: 
            case CTYPE: 
            case DATE: 
            case DESC: 
            case FILENAME: 
            case TYPE: {
                if (this.attachment == null) break;
                RepositoryTaskAttribute attr = this.attributeFactory.createAttribute(tag.getKeyString());
                attr.setValue(parsedText);
                this.attachment.addAttribute(tag.getKeyString(), attr);
                break;
            }
            case DATA: {
                break;
            }
            case ATTACHMENT: {
                if (this.attachment == null) break;
                this.repositoryTaskData.addAttachment(this.attachment);
                break;
            }
            case BUGZILLA: {
                break;
            }
            case BUG: {
                RepositoryTaskAttribute numCommentsAttribute = this.repositoryTaskData.getAttribute(BugzillaReportElement.LONGDESCLENGTH.getKeyString());
                if (numCommentsAttribute == null) {
                    numCommentsAttribute = this.attributeFactory.createAttribute(BugzillaReportElement.LONGDESCLENGTH.getKeyString());
                    numCommentsAttribute.setValue("" + this.repositoryTaskData.getComments().size());
                    this.repositoryTaskData.addAttribute(BugzillaReportElement.LONGDESCLENGTH.getKeyString(), numCommentsAttribute);
                } else {
                    numCommentsAttribute.setValue("" + this.repositoryTaskData.getComments().size());
                }
                for (RepositoryAttachment attachment : this.repositoryTaskData.getAttachments()) {
                    TaskComment taskComment = this.attachIdToComment.get(attachment.getId());
                    if (taskComment != null) {
                        attachment.setCreator(taskComment.getAuthor());
                    }
                    attachment.setAttributeValue("task.common.attachment.url", String.valueOf(this.repositoryTaskData.getRepositoryUrl()) + "/attachment.cgi?id=" + attachment.getId());
                    attachment.setRepositoryKind(this.repositoryTaskData.getRepositoryKind());
                    attachment.setRepositoryUrl(this.repositoryTaskData.getRepositoryUrl());
                    attachment.setTaskId(this.repositoryTaskData.getId());
                }
                break;
            }
            case BLOCKED: 
            case DEPENDSON: {
                RepositoryTaskAttribute dependancyAttribute = this.repositoryTaskData.getAttribute(tag.getKeyString());
                if (dependancyAttribute == null) {
                    dependancyAttribute = this.attributeFactory.createAttribute(tag.getKeyString());
                    dependancyAttribute.setValue(parsedText);
                    this.repositoryTaskData.addAttribute(tag.getKeyString(), dependancyAttribute);
                    break;
                }
                if (dependancyAttribute.getValue().equals("")) {
                    dependancyAttribute.setValue(parsedText);
                    break;
                }
                dependancyAttribute.setValue(String.valueOf(dependancyAttribute.getValue()) + ", " + parsedText);
                break;
            }
            default: {
                RepositoryTaskAttribute attribute = this.repositoryTaskData.getAttribute(tag.getKeyString());
                if (attribute == null) {
                    attribute = this.attributeFactory.createAttribute(tag.getKeyString());
                    attribute.setValue(parsedText);
                    this.repositoryTaskData.addAttribute(tag.getKeyString(), attribute);
                    break;
                }
                attribute.addValue(parsedText);
            }
        }
    }

    private void parseAttachment(TaskComment taskComment, String commentText) {
        int endIndex;
        String attachmentID = "";
        if (commentText.startsWith(COMMENT_ATTACHMENT_STRING) && (endIndex = commentText.indexOf(")")) > 0 && endIndex < commentText.length() && !(attachmentID = commentText.substring(COMMENT_ATTACHMENT_STRING.length(), endIndex)).equals("")) {
            taskComment.setHasAttachment(true);
            taskComment.setAttachmentId(attachmentID);
            this.attachIdToComment.put(attachmentID, taskComment);
        }
    }
}

