/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.DegreeOfInterest;
import org.eclipse.mylyn.internal.context.core.InteractionContextElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextRelation;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionContext
implements IInteractionContext {
    private String handleIdentifier;
    private List<InteractionEvent> interactionHistory = new CopyOnWriteArrayList<InteractionEvent>();
    protected ConcurrentHashMap<String, InteractionContextElement> elementMap;
    protected Map<String, IInteractionElement> landmarkMap;
    protected InteractionContextElement activeNode = null;
    private InteractionEvent lastEdgeEvent = null;
    private InteractionContextElement lastEdgeNode = null;
    public String contentLimitedTo = null;
    private int numUserEvents = 0;
    protected InteractionContextScaling contextScaling;

    void parseInteractionHistory() {
        this.elementMap = new ConcurrentHashMap();
        this.landmarkMap = new HashMap<String, IInteractionElement>();
        for (InteractionEvent event : this.interactionHistory) {
            this.parseInteractionEvent(event);
        }
        this.updateLandmarks();
        this.activeNode = this.lastEdgeNode;
    }

    public InteractionContext(String id, InteractionContextScaling scaling) {
        this.handleIdentifier = id;
        this.contextScaling = scaling;
        this.parseInteractionHistory();
    }

    public IInteractionElement parseEvent(InteractionEvent event) {
        this.interactionHistory.add(event);
        return this.parseInteractionEvent(event);
    }

    private IInteractionElement parseInteractionEvent(InteractionEvent event) {
        IInteractionElement navigationSource;
        InteractionContextElement node;
        if (event.getStructureHandle() == null) {
            return null;
        }
        if (event.getKind().isUserEvent()) {
            ++this.numUserEvents;
        }
        if ((node = this.elementMap.get(event.getStructureHandle())) == null) {
            node = new InteractionContextElement(event.getStructureKind(), event.getStructureHandle(), this);
            this.elementMap.put(event.getStructureHandle(), node);
        }
        if (event.getNavigation() != null && !event.getNavigation().equals("null") && this.lastEdgeEvent != null && this.lastEdgeNode != null && this.lastEdgeEvent.getStructureHandle() != null && event.getKind() != InteractionEvent.Kind.PROPAGATION && event.getKind() != InteractionEvent.Kind.PREDICTION && (navigationSource = (IInteractionElement)this.elementMap.get(this.lastEdgeEvent.getStructureHandle())) != null) {
            InteractionContextRelation edge = this.lastEdgeNode.getRelation(event.getStructureHandle());
            if (edge == null) {
                edge = new InteractionContextRelation(event.getStructureKind(), event.getNavigation(), this.lastEdgeNode, node, this);
                this.lastEdgeNode.addEdge(edge);
            }
            DegreeOfInterest doi = (DegreeOfInterest)edge.getInterest();
            doi.addEvent(event);
        }
        DegreeOfInterest doi = (DegreeOfInterest)node.getInterest();
        doi.addEvent(event);
        if (doi.isLandmark()) {
            this.landmarkMap.put(node.getHandleIdentifier(), node);
        } else {
            this.landmarkMap.remove(node.getHandleIdentifier());
        }
        if (event.getKind().isUserEvent()) {
            this.lastEdgeEvent = event;
            this.lastEdgeNode = node;
            this.activeNode = node;
        }
        return node;
    }

    private void updateLandmarks() {
        for (InteractionContextElement node : this.elementMap.values()) {
            if (!node.getInterest().isLandmark()) continue;
            this.landmarkMap.put(node.getHandleIdentifier(), node);
        }
    }

    @Override
    public IInteractionElement get(String elementHandle) {
        if (elementHandle == null) {
            return null;
        }
        return this.elementMap.get(elementHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IInteractionElement> getInteresting() {
        ArrayList<IInteractionElement> elements = new ArrayList<IInteractionElement>();
        ConcurrentHashMap<String, InteractionContextElement> concurrentHashMap = this.elementMap;
        synchronized (concurrentHashMap) {
            for (String key : this.elementMap.keySet()) {
                InteractionContextElement info = this.elementMap.get(key);
                if (info == null || !info.getInterest().isInteresting()) continue;
                elements.add(info);
            }
        }
        return elements;
    }

    @Override
    public List<IInteractionElement> getLandmarks() {
        return Collections.unmodifiableList(new ArrayList<IInteractionElement>(this.landmarkMap.values()));
    }

    @Override
    public void updateElementHandle(IInteractionElement element, String newHandle) {
        InteractionContextElement currElement = this.elementMap.remove(element.getHandleIdentifier());
        if (currElement != null) {
            currElement.setHandleIdentifier(newHandle);
            this.elementMap.put(newHandle, currElement);
        }
    }

    @Override
    public IInteractionElement getActiveNode() {
        return this.activeNode;
    }

    @Override
    public void delete(IInteractionElement node) {
        this.landmarkMap.remove(node.getHandleIdentifier());
        this.elementMap.remove(node.getHandleIdentifier());
    }

    @Override
    public List<IInteractionElement> getAllElements() {
        return new ArrayList<IInteractionElement>(this.elementMap.values());
    }

    @Override
    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    public void setHandleIdentifier(String handle) {
        this.handleIdentifier = handle;
    }

    public String toString() {
        return this.handleIdentifier;
    }

    public void reset() {
        this.interactionHistory.clear();
        this.elementMap.clear();
        this.interactionHistory.clear();
        this.landmarkMap.clear();
        this.activeNode = null;
    }

    public int getUserEventCount() {
        return this.numUserEvents;
    }

    @Override
    public List<InteractionEvent> getInteractionHistory() {
        return this.interactionHistory;
    }

    public void collapse() {
        ArrayList<InteractionEvent> collapsedHistory = new ArrayList<InteractionEvent>();
        for (InteractionContextElement node : this.elementMap.values()) {
            if (node.equals(this.activeNode)) continue;
            this.collapseNode(collapsedHistory, node);
        }
        this.collapseNode(collapsedHistory, this.activeNode);
        this.interactionHistory.clear();
        this.interactionHistory.addAll(collapsedHistory);
    }

    private void collapseNode(List<InteractionEvent> collapsedHistory, InteractionContextElement node) {
        if (node != null) {
            collapsedHistory.addAll(((DegreeOfInterest)node.getInterest()).getCollapsedEvents());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InteractionContext other = (InteractionContext)obj;
        if (this.contentLimitedTo == null ? other.contentLimitedTo != null : !this.contentLimitedTo.equals(other.contentLimitedTo)) {
            return false;
        }
        return !(this.handleIdentifier == null ? other.handleIdentifier != null : !this.handleIdentifier.equals(other.handleIdentifier));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.contentLimitedTo == null ? 0 : this.contentLimitedTo.hashCode());
        result = 31 * result + (this.handleIdentifier == null ? 0 : this.handleIdentifier.hashCode());
        return result;
    }

    @Override
    public InteractionContextScaling getScaling() {
        return this.contextScaling;
    }

    @Override
    public String getContentLimitedTo() {
        return this.contentLimitedTo;
    }

    @Override
    public void setContentLimitedTo(String contentLimitedTo) {
        this.contentLimitedTo = contentLimitedTo;
    }
}

