/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.mylyn.context.core.IInteractionContextReader;
import org.eclipse.mylyn.context.core.IInteractionContextWriter;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.SaxContextReader;
import org.eclipse.mylyn.internal.context.core.SaxContextWriter;
import org.eclipse.mylyn.monitor.core.StatusHandler;

public class InteractionContextExternalizer {
    public static final String ELMNT_INTERACTION_HISTORY_OLD = "interactionEvent";
    public static final String ELMNT_INTERACTION_HISTORY = "InteractionHistory";
    public static final String ATR_STRUCTURE_KIND = "StructureKind";
    public static final String ATR_STRUCTURE_HANDLE = "StructureHandle";
    public static final String ATR_START_DATE = "StartDate";
    public static final String ATR_ORIGIN_ID = "OriginId";
    public static final String ATR_NAVIGATION = "Navigation";
    public static final String ATR_KIND = "Kind";
    public static final String ATR_INTEREST = "Interest";
    public static final String ATR_DELTA = "Delta";
    public static final String ATR_END_DATE = "EndDate";
    public static final String ATR_ID = "Id";
    public static final String ATR_VERSION = "Version";
    static final String DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.S z";

    public void writeContextToXml(InteractionContext context, File file) {
        this.writeContextToXml(context, file, new SaxContextWriter());
    }

    public void writeContextToXml(InteractionContext context, File file, IInteractionContextWriter writer) {
        if (context.getInteractionHistory().isEmpty()) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream outputStream = null;
        try {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                fileOutputStream = new FileOutputStream(file);
                outputStream = new ZipOutputStream(fileOutputStream);
                this.writeContext(context, outputStream, writer);
            }
            catch (IOException e) {
                StatusHandler.fail((Throwable)e, (String)("Could not write: " + file.getAbsolutePath()), (boolean)true);
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException e2) {
                    StatusHandler.fail((Throwable)e2, (String)("Unable to write context " + context.getHandleIdentifier()), (boolean)false);
                }
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                StatusHandler.fail((Throwable)e, (String)("Unable to write context " + context.getHandleIdentifier()), (boolean)false);
            }
        }
    }

    public void writeContext(InteractionContext context, ZipOutputStream outputStream) throws IOException {
        this.writeContext(context, outputStream, new SaxContextWriter());
    }

    public void writeContext(InteractionContext context, ZipOutputStream outputStream, IInteractionContextWriter writer) throws IOException {
        String handleIdentifier = context.getHandleIdentifier();
        String encoded = URLEncoder.encode(handleIdentifier, "UTF-8");
        ZipEntry zipEntry = new ZipEntry(String.valueOf(encoded) + ".xml");
        outputStream.putNextEntry(zipEntry);
        outputStream.setMethod(8);
        writer.setOutputStream(outputStream);
        writer.writeContextToStream(context);
        outputStream.flush();
        outputStream.closeEntry();
    }

    public InteractionContext readContextFromXML(String handleIdentifier, File file, InteractionContextScaling scaling) {
        return this.readContextFromXML(handleIdentifier, file, new SaxContextReader(), scaling);
    }

    public InteractionContext readContextFromXML(String handleIdentifier, File file, IInteractionContextReader reader, InteractionContextScaling scaling) {
        block4: {
            try {
                if (file.exists()) break block4;
                return null;
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)("Could not read: " + file.getAbsolutePath()), (boolean)true);
                return null;
            }
        }
        if (reader instanceof SaxContextReader) {
            ((SaxContextReader)reader).setContextScaling(scaling);
        }
        return reader.readContext(handleIdentifier, file);
    }
}

