/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.osgi.service.prefs.BackingStoreException;

public class TeamPropertiesLinkProvider {
    private static final String PROJECT_COMMIT_COMMENT_TEMPLATE = "commit.comment.template";

    public boolean canAccessProperties(IResource resource) {
        IProject project = resource.getProject();
        return project != null && project.isAccessible();
    }

    public String getCommitCommentTemplate(IResource resource) {
        if (!this.canAccessProperties(resource)) {
            return null;
        }
        ProjectScope projectScope = new ProjectScope(resource.getProject());
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.mylyn.team.ui");
        if (projectNode != null) {
            return projectNode.get(PROJECT_COMMIT_COMMENT_TEMPLATE, null);
        }
        return null;
    }

    public boolean setCommitCommentTemplate(IResource resource, String commitCommentTemplate) {
        if (!this.canAccessProperties(resource)) {
            return false;
        }
        ProjectScope projectScope = new ProjectScope(resource.getProject());
        IEclipsePreferences projectNode = projectScope.getNode("org.eclipse.mylyn.team.ui");
        if (projectNode != null) {
            if (commitCommentTemplate != null) {
                projectNode.put(PROJECT_COMMIT_COMMENT_TEMPLATE, commitCommentTemplate);
            } else {
                projectNode.remove(PROJECT_COMMIT_COMMENT_TEMPLATE);
            }
            try {
                projectNode.flush();
                return true;
            }
            catch (BackingStoreException e) {
                StatusHandler.fail((Throwable)e, (String)"Failed to save commit comment template for project", (boolean)false);
            }
        }
        return false;
    }
}

