/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.ui;

import java.util.Set;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public abstract class AbstractContextChangeSetManager
implements IInteractionContextListener {
    protected boolean isEnabled = false;
    private ITaskActivityListener TASK_ACTIVITY_LISTENER = new ITaskActivityListener(){

        public void taskListRead() {
            AbstractContextChangeSetManager.this.initContextChangeSets();
        }

        public void taskActivated(AbstractTask task) {
        }

        public void taskDeactivated(AbstractTask task) {
        }

        public void activityChanged(ScheduledTaskContainer week) {
        }
    };
    private ITaskListChangeListener TASK_CHANGE_LISTENER = new ITaskListChangeListener(){

        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                if (!(taskContainerDelta.getContainer() instanceof AbstractTask)) continue;
                AbstractTask task = (AbstractTask)taskContainerDelta.getContainer();
                switch (taskContainerDelta.getKind()) {
                    case CHANGED: {
                        AbstractContextChangeSetManager.this.updateChangeSetLabel(task);
                    }
                }
            }
        }
    };

    public void enable() {
        if (!this.isEnabled) {
            this.isEnabled = true;
            TasksUiPlugin.getTaskListManager().getTaskList().addChangeListener(this.TASK_CHANGE_LISTENER);
            TasksUiPlugin.getTaskListManager().addActivityListener(this.TASK_ACTIVITY_LISTENER);
            if (TasksUiPlugin.getTaskListManager().isTaskListInitialized()) {
                this.initContextChangeSets();
            }
            if (ContextCorePlugin.getContextManager().isContextActive()) {
                this.contextActivated(ContextCorePlugin.getContextManager().getActiveContext());
            }
            ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this);
        }
    }

    public void disable() {
        ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this);
        TasksUiPlugin.getTaskListManager().removeActivityListener(this.TASK_ACTIVITY_LISTENER);
        TasksUiPlugin.getTaskListManager().getTaskList().removeChangeListener(this.TASK_CHANGE_LISTENER);
        this.isEnabled = false;
    }

    protected abstract void initContextChangeSets();

    protected abstract void updateChangeSetLabel(AbstractTask var1);

    public void elementDeleted(IInteractionElement node) {
    }

    public void landmarkAdded(IInteractionElement node) {
    }

    public void landmarkRemoved(IInteractionElement node) {
    }

    public void relationsChanged(IInteractionElement node) {
    }
}

