/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.dev.properties;

import org.eclipse.mylyn.internal.sandbox.dev.properties.AbstractTaskContainerPropertySource;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class AbstractTaskPropertiesSource
extends AbstractTaskContainerPropertySource
implements IPropertySource {
    private static final String NULL_MSG = "<null>";
    private static final String LAST_READ = "last_read";
    private static final String STATE = "state";
    private static final String STATUS = "status";
    private static final String URL = "url";
    private static final String KIND = "kind";
    private static final String OWNER = "owner";
    private static final String PARENT = "parent";
    private static final String SCHEDULED = "scheduled";

    public AbstractTaskPropertiesSource(AbstractTask adaptableObject) {
        super((AbstractTaskContainer)adaptableObject);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        TextPropertyDescriptor summary = new TextPropertyDescriptor((Object)"summary", "Summary");
        summary.setCategory(this.description);
        TextPropertyDescriptor owner = new TextPropertyDescriptor((Object)OWNER, "Owner");
        owner.setCategory(this.description);
        TextPropertyDescriptor scheduled = new TextPropertyDescriptor((Object)SCHEDULED, "Scheduled for");
        scheduled.setCategory(this.description);
        TextPropertyDescriptor parent = new TextPropertyDescriptor((Object)PARENT, "Parent Containers");
        parent.setCategory(this.description);
        TextPropertyDescriptor kind = new TextPropertyDescriptor((Object)KIND, "Repository Connector Kind");
        kind.setCategory(this.description);
        TextPropertyDescriptor url = new TextPropertyDescriptor((Object)URL, "Repository URL");
        url.setCategory(this.description);
        TextPropertyDescriptor status = new TextPropertyDescriptor((Object)STATUS, "Synchronization Status");
        status.setCategory(this.description);
        TextPropertyDescriptor state = new TextPropertyDescriptor((Object)STATE, "Synchronization State");
        state.setCategory(this.description);
        TextPropertyDescriptor lastRead = new TextPropertyDescriptor((Object)LAST_READ, "Last Read Timestamp");
        lastRead.setCategory(this.description);
        IPropertyDescriptor[] specific = new IPropertyDescriptor[]{summary, owner, scheduled, parent, kind, url, status, state, lastRead};
        return super.appendSpecifics(specific, super.getPropertyDescriptors());
    }

    public Object getPropertyValue(Object id) {
        AbstractTask task = (AbstractTask)this.container;
        if ("summary".equals(id)) {
            return task.getSummary();
        }
        if (OWNER.equals(id)) {
            return task.getOwner();
        }
        if (SCHEDULED.equals(id)) {
            return task.getScheduledForDate() == null ? NULL_MSG : task.getScheduledForDate();
        }
        if (PARENT.equals(id)) {
            return task.getParentContainers() == null ? NULL_MSG : task.getParentContainers().toString();
        }
        if (KIND.equals(id)) {
            return task.getConnectorKind();
        }
        if (URL.equals(id)) {
            return task.getRepositoryUrl();
        }
        if (STATE.equals(id)) {
            return task.getSynchronizationState() == null ? NULL_MSG : task.getSynchronizationState().toString();
        }
        if (STATUS.equals(id)) {
            return task.getSynchronizationStatus() == null ? NULL_MSG : task.getSynchronizationStatus().toString();
        }
        if (LAST_READ.equals(id)) {
            return task.getLastReadTimeStamp() == null ? NULL_MSG : task.getLastReadTimeStamp().toString();
        }
        return super.getPropertyValue(id);
    }
}

