/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.mylyn.context.core.InterestComparator;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearchJob;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearchOperation;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaReportInfo;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaSearchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaMylynSearch
implements IActiveSearchOperation {
    public static final int LOCAL_QUAL = 1;
    public static final int LOCAL_UNQUAL = 2;
    public static final int FULLY_QUAL = 3;
    public static final int UNQUAL = 4;
    private int scope;
    private IJavaElement element;
    private String handle = "";
    private String serverUrl = "";
    private List<IActiveSearchListener> listeners = new ArrayList<IActiveSearchListener>();

    public BugzillaMylynSearch(int scope, IJavaElement element, String serverUrl) {
        this.scope = scope;
        this.element = element;
        this.serverUrl = serverUrl;
    }

    public IStatus run(IProgressMonitor monitor) {
        return this.run(monitor, 50);
    }

    public IStatus run(IProgressMonitor monitor, int priority) {
        this.handle = String.valueOf(this.element.getHandleIdentifier()) + " " + this.scope;
        ArrayList<IJavaElement> landmarks = new ArrayList<IJavaElement>();
        landmarks.add(this.element);
        if (!BugzillaSearchManager.doesJobExist(this.handle)) {
            List<IMember> members = BugzillaMylynSearch.getMemberLandmarks(landmarks);
            for (IMember m : members) {
                BugzillaMylynSearchOperation op = new BugzillaMylynSearchOperation(this, m, this.scope);
                BugzillaMylynSearchJob searchJob = new BugzillaMylynSearchJob("Querying Bugzilla Server - Mylar - " + op.getSearchMemberName(), op);
                searchJob.setPriority(priority);
                searchJob.schedule();
                BugzillaSearchManager.addJob(this.handle, searchJob);
            }
        }
        return Status.OK_STATUS;
    }

    public void addListener(IActiveSearchListener l) {
        this.listeners.add(l);
    }

    public void removeListener(IActiveSearchListener l) {
        this.listeners.remove(l);
    }

    public void notifySearchCompleted(List<BugzillaReportInfo> doiList) {
        BugzillaSearchManager.removeSearchJob(this.handle);
        for (IActiveSearchListener listener : this.listeners) {
            listener.searchCompleted(doiList);
        }
    }

    public static List<IMember> getMemberLandmarks(List<IJavaElement> landmarks) {
        ArrayList<IMember> memberLandmarks = new ArrayList<IMember>();
        for (IJavaElement je : landmarks) {
            if (!(je instanceof IMember)) continue;
            memberLandmarks.add((IMember)je);
        }
        Collections.sort(memberLandmarks, new InterestComparator());
        return memberLandmarks;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }
}

