/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.dev.properties;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskContainerPropertySource
implements IPropertySource {
    protected static final String CHILDREN = "children";
    protected static final String DESCENDANDS = "descendents";
    protected static final String IS_CYCLIC = "iscyclic";
    protected static final String SUMMARY = "summary";
    private boolean cyclic;
    protected AbstractTaskContainer container;
    protected String description;

    public AbstractTaskContainerPropertySource(AbstractTaskContainer adaptableObject) {
        this.container = adaptableObject;
        this.description = this.container.getClass().getName();
    }

    public Set<AbstractTask> getDescendants(AbstractTaskContainer parent) {
        HashSet<AbstractTask> childrenWithoutCycles = new HashSet<AbstractTask>();
        this.getDescendantsHelper(parent, childrenWithoutCycles, parent);
        return Collections.unmodifiableSet(childrenWithoutCycles);
    }

    protected void getDescendantsHelper(AbstractTaskContainer parent, Set<AbstractTask> visited, AbstractTaskContainer root) {
        for (AbstractTask child : parent.getChildrenInternal()) {
            if (child == root) {
                this.cyclic = true;
            }
            if (visited.contains(child) || child == root) continue;
            visited.add(child);
            this.getDescendantsHelper((AbstractTaskContainer)child, visited, root);
        }
    }

    public boolean containsCyclic(AbstractTaskContainer parent) {
        HashSet<AbstractTask> childrenWithoutCycles = new HashSet<AbstractTask>();
        HashSet<AbstractTaskContainer> parentStack = new HashSet<AbstractTaskContainer>();
        this.cyclic = false;
        this.containsCyclicHelper(parent, childrenWithoutCycles, parentStack);
        return this.cyclic;
    }

    protected void containsCyclicHelper(AbstractTaskContainer parent, Set<AbstractTask> visited, Set<AbstractTaskContainer> parentStack) {
        if (this.cyclic) {
            return;
        }
        parentStack.add(parent);
        for (AbstractTask child : parent.getChildrenInternal()) {
            if (parentStack.contains(child)) {
                this.cyclic = true;
                return;
            }
            this.containsCyclicHelper((AbstractTaskContainer)child, visited, parentStack);
        }
        parentStack.remove(parent);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        TextPropertyDescriptor children = new TextPropertyDescriptor((Object)CHILDREN, "Total Children (internal)");
        children.setCategory(this.description);
        TextPropertyDescriptor descendants = new TextPropertyDescriptor((Object)DESCENDANDS, "Total Descendants");
        descendants.setCategory(this.description);
        TextPropertyDescriptor cyclic = new TextPropertyDescriptor((Object)IS_CYCLIC, "Cycle in descendants graph?");
        cyclic.setCategory(this.description);
        return new IPropertyDescriptor[]{children, descendants, cyclic};
    }

    public Object getPropertyValue(Object id) {
        if (CHILDREN.equals(id)) {
            return this.container.getChildrenInternal().size();
        }
        if (DESCENDANDS.equals(id)) {
            return this.getDescendants(this.container).size();
        }
        if (IS_CYCLIC.equals(id)) {
            return this.containsCyclic(this.container) ? "Cyclic" : "Not Cyclic";
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] appendSpecifics(IPropertyDescriptor[] specific, IPropertyDescriptor[] these) {
        IPropertyDescriptor[] all = new IPropertyDescriptor[specific.length + these.length];
        System.arraycopy(these, 0, all, 0, these.length);
        System.arraycopy(specific, 0, all, these.length, specific.length);
        return all;
    }
}

