/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.dev.properties;

import org.eclipse.mylyn.internal.sandbox.dev.properties.AbstractTaskContainerPropertySource;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class RepositoryQueryPropertySource
extends AbstractTaskContainerPropertySource
implements IPropertySource {
    private static final String NULL_MSG = "<null>";
    private static final String LAST_READ = "last_read";
    private static final String STATUS = "status";
    private static final String URL = "url";
    private static final String KIND = "kind";

    public RepositoryQueryPropertySource(AbstractRepositoryQuery adaptableObject) {
        super((AbstractTaskContainer)adaptableObject);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        TextPropertyDescriptor summary = new TextPropertyDescriptor((Object)"summary", "Query Summary");
        summary.setCategory(this.description);
        TextPropertyDescriptor kind = new TextPropertyDescriptor((Object)KIND, "Repository Connector Kind");
        kind.setCategory(this.description);
        TextPropertyDescriptor url = new TextPropertyDescriptor((Object)URL, "Repository URL");
        url.setCategory(this.description);
        TextPropertyDescriptor status = new TextPropertyDescriptor((Object)STATUS, "Synchronization Status");
        status.setCategory(this.description);
        TextPropertyDescriptor lastRead = new TextPropertyDescriptor((Object)LAST_READ, "Synchronization Timestamp");
        lastRead.setCategory(this.description);
        IPropertyDescriptor[] specific = new IPropertyDescriptor[]{summary, kind, url, status, lastRead};
        return super.appendSpecifics(specific, super.getPropertyDescriptors());
    }

    public Object getPropertyValue(Object id) {
        AbstractRepositoryQuery query = (AbstractRepositoryQuery)this.container;
        if ("summary".equals(id)) {
            return query.getSummary();
        }
        if (KIND.equals(id)) {
            return query.getRepositoryKind();
        }
        if (URL.equals(id)) {
            return query.getRepositoryUrl();
        }
        if (STATUS.equals(id)) {
            return query.getSynchronizationStatus() == null ? NULL_MSG : query.getSynchronizationStatus().toString();
        }
        if (LAST_READ.equals(id)) {
            return query.getLastSynchronizedTimeStamp() == null ? NULL_MSG : query.getLastSynchronizedTimeStamp().toString();
        }
        return super.getPropertyValue(id);
    }
}

