/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.bridge.bugs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.internal.bugzilla.ui.tasklist.StackTrace;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaMylynSearch;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaReportInfo;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.BugzillaSearchEngine;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.IBugzillaSearchOperation;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.MylynBugsManager;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.ProgressQueryHitCollector;
import org.eclipse.mylyn.internal.sandbox.bridge.bugs.Util;
import org.eclipse.mylyn.internal.tasks.ui.search.AbstractRepositorySearchQuery;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaMylynSearchOperation
extends WorkspaceModifyOperation
implements IBugzillaSearchOperation {
    private IMember javaElement;
    private ProgressQueryHitCollector collector = null;
    private IStatus status;
    private LoginException loginException = null;
    private String name;
    private AbstractRepositorySearchQuery query;
    private BugzillaMylynSearch search;
    private int scope;

    public BugzillaMylynSearchOperation(BugzillaMylynSearch search, IMember m, int scope) {
        this.javaElement = m;
        this.search = search;
        this.scope = scope;
        this.name = BugzillaMylynSearchOperation.getFullyQualifiedName((IJavaElement)m);
    }

    public static String getFullyQualifiedName(IJavaElement je) {
        if (!(je instanceof IMember)) {
            return null;
        }
        IMember m = (IMember)je;
        if (m.getDeclaringType() == null) {
            return ((IType)m).getFullyQualifiedName();
        }
        return String.valueOf(m.getDeclaringType().getFullyQualifiedName()) + "." + m.getElementName();
    }

    public void execute(IProgressMonitor monitor) {
        ProgressQueryHitCollector searchCollector = null;
        if (this.scope == 3) {
            searchCollector = this.searchQualified(this.search.getServerUrl(), monitor);
        } else if (this.scope == 4) {
            searchCollector = this.searchUnqualified(this.search.getServerUrl(), monitor);
        } else if (this.scope == 1) {
            searchCollector = this.searchLocalQual(monitor);
        } else if (this.scope == 2) {
            searchCollector = this.searchLocalUnQual(monitor);
        } else {
            this.status = Status.OK_STATUS;
            return;
        }
        if (searchCollector == null) {
            this.search.notifySearchCompleted(new ArrayList<BugzillaReportInfo>());
            return;
        }
        Set<AbstractTask> l = searchCollector.getTasks();
        List<BugzillaReportInfo> doiList = this.getDoiList(l);
        MylynBugsManager.getBridge().addToLandmarksHash(doiList, this.javaElement, this.scope);
        this.search.notifySearchCompleted(doiList);
    }

    private ProgressQueryHitCollector searchLocalQual(IProgressMonitor monitor) {
        String elementName = BugzillaMylynSearchOperation.getFullyQualifiedName((IJavaElement)this.javaElement);
        this.collector = new ProgressQueryHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        Set tasks = TasksUiPlugin.getTaskListManager().getTaskList().getOrphanContainer("local").getChildren();
        this.searchLocal(tasks, this.collector, elementName, monitor);
        for (AbstractTaskContainer cat : TasksUiPlugin.getTaskListManager().getTaskList().getTaskContainers()) {
            this.searchLocal(cat.getChildren(), this.collector, elementName, monitor);
        }
        return this.collector;
    }

    private ProgressQueryHitCollector searchLocalUnQual(IProgressMonitor monitor) {
        String elementName = this.javaElement.getElementName();
        this.collector = new ProgressQueryHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        Set tasks = TasksUiPlugin.getTaskListManager().getTaskList().getOrphanContainer("local").getChildren();
        this.searchLocal(tasks, this.collector, elementName, monitor);
        for (AbstractTaskContainer cat : TasksUiPlugin.getTaskListManager().getTaskList().getTaskContainers()) {
            this.searchLocal(cat.getChildren(), this.collector, elementName, monitor);
        }
        return this.collector;
    }

    private void searchLocal(Set<AbstractTask> tasks, ProgressQueryHitCollector searchCollector, String elementName, IProgressMonitor monitor) {
        if (tasks == null) {
            return;
        }
        for (AbstractTask task : tasks) {
            monitor.worked(1);
            if (!(task instanceof BugzillaTask)) continue;
            BugzillaTask bugTask = (BugzillaTask)task;
            RepositoryTaskData bugTaskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(bugTask.getRepositoryUrl(), bugTask.getTaskId());
            boolean isHit = this.search(elementName, bugTaskData);
            if (!isHit) continue;
            searchCollector.accept((AbstractTask)bugTask);
        }
        this.status = Status.OK_STATUS;
    }

    private boolean search(String elementName, RepositoryTaskData bug) {
        if (bug == null) {
            return false;
        }
        String description = bug.getDescription();
        String summary = bug.getSummary();
        List taskComments = bug.getComments();
        if (Util.hasElementName(elementName, summary)) {
            return true;
        }
        if (Util.hasElementName(elementName, description)) {
            return true;
        }
        for (TaskComment taskComment : taskComments) {
            String commentText = taskComment.getText();
            if (!Util.hasElementName(elementName, commentText)) continue;
            return true;
        }
        return false;
    }

    private ProgressQueryHitCollector search(String url, TaskRepository repository, ProgressQueryHitCollector searchCollector, IProgressMonitor monitor) {
        block5: {
            block4: {
                int matches = 0;
                searchCollector.setProgressMonitor(monitor);
                BugzillaSearchEngine engine = new BugzillaSearchEngine(repository, url);
                try {
                    this.status = engine.search(searchCollector, matches);
                    if (this.status.getCode() != 8) break block4;
                    return null;
                }
                catch (LoginException e) {
                    this.loginException = e;
                    return null;
                }
            }
            if (this.status.isOK()) break block5;
            StatusHandler.log((String)"search error", (Object)this);
            StatusHandler.log((IStatus)this.status);
            return null;
        }
        return searchCollector;
    }

    private ProgressQueryHitCollector searchQualified(String repositoryUrl, IProgressMonitor monitor) {
        this.collector = new ProgressQueryHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        String url = Util.getExactSearchURL(repositoryUrl, this.javaElement);
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("bugzilla", repositoryUrl);
        return this.search(url, repository, this.collector, monitor);
    }

    private ProgressQueryHitCollector searchUnqualified(String repositoryUrl, IProgressMonitor monitor) {
        this.collector = new ProgressQueryHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), (ITaskFactory)new TaskFactory(null));
        this.collector.setProgressMonitor(monitor);
        String url = Util.getInexactSearchURL(repositoryUrl, this.javaElement);
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("bugzilla", repositoryUrl);
        return this.search(url, repository, this.collector, monitor);
    }

    public static void secondPassBugzillaParser(List<BugzillaReportInfo> doiList) {
        for (BugzillaReportInfo info : doiList) {
            RepositoryTaskData b = null;
            try {
                b = info.getBug();
            }
            catch (Exception exception) {}
            if (b == null) continue;
            StackTrace[] stackTrace = StackTrace.getStackTrace((String)b.getDescription(), (Object)b.getDescription());
            if (stackTrace != null) {
                info.setExact(true);
                info.addStackTraces(stackTrace);
            }
            for (TaskComment taskComment : b.getComments()) {
                String commentText = taskComment.getText();
                stackTrace = StackTrace.getStackTrace((String)commentText, (Object)taskComment);
                if (stackTrace == null) continue;
                info.setExact(true);
                info.addStackTraces(stackTrace);
            }
        }
    }

    private List<BugzillaReportInfo> getDoiList(Set<AbstractTask> results) {
        ArrayList<BugzillaReportInfo> doiList = new ArrayList<BugzillaReportInfo>();
        boolean isExact = this.scope == 3 || this.scope == 1;
        BugzillaReportInfo info = null;
        for (AbstractTask hit : results) {
            try {
                try {
                    float value = 0.0f;
                    info = new BugzillaReportInfo(value, (BugzillaTask)hit, isExact);
                }
                catch (Exception e) {
                    StatusHandler.log((Throwable)e, (String)"search failed");
                    doiList.add(info);
                    continue;
                }
            }
            catch (Throwable throwable) {
                doiList.add(info);
                throw throwable;
            }
            doiList.add(info);
        }
        return doiList;
    }

    @Override
    public IStatus getStatus() throws LoginException {
        if (this.loginException == null) {
            return this.status;
        }
        throw this.loginException;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IMember getSearchMember() {
        return this.javaElement;
    }

    public String getSearchMemberName() {
        return this.name;
    }

    @Override
    public AbstractRepositorySearchQuery getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(AbstractRepositorySearchQuery newQuery) {
        this.query = newQuery;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getScope() {
        return this.scope;
    }
}

