/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class IncomingTaskListContentProvider
extends TaskListContentProvider {
    Set<AbstractTaskContainer> people = new HashSet<AbstractTaskContainer>();

    public IncomingTaskListContentProvider(TaskListView taskListView) {
        super(taskListView);
    }

    public Object[] getElements(Object parent) {
        this.people.clear();
        for (AbstractTaskContainer container : this.applyFilter(TasksUiPlugin.getTaskListManager().getTaskList().getRootElements())) {
            for (AbstractTask task : container.getChildren()) {
                if (task.getOwner() == null || task.getSynchronizationState() == null || !task.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.INCOMING)) continue;
                this.people.add((AbstractTaskContainer)new Person(task.getOwner(), task.getConnectorKind(), task.getRepositoryUrl()));
            }
        }
        return this.people.toArray();
    }

    public Object[] getChildren(Object parent) {
        HashSet<AbstractTask> children = new HashSet<AbstractTask>();
        if (parent instanceof Person) {
            for (AbstractTaskContainer container : this.applyFilter(TasksUiPlugin.getTaskListManager().getTaskList().getRootElements())) {
                for (AbstractTask task : container.getChildren()) {
                    if (task.getOwner() == null || !task.getOwner().equals(((Person)parent).getHandleIdentifier()) || task.getSynchronizationState() == null || !task.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.INCOMING)) continue;
                    children.add(task);
                }
            }
        }
        return children.toArray();
    }

    public boolean hasChildren(Object parent) {
        return parent instanceof Person;
    }
}

