/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.wiki.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.wiki.TracWikiPageHistoryPageSource;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class TracWikiPageEditorInput
implements IEditorInput {
    private TaskRepository repository;
    private TracWikiPage page;
    private String pageUrl;
    private static TracWikiPageHistoryPageSource historyPageSource = new TracWikiPageHistoryPageSource();

    public TracWikiPageEditorInput(TaskRepository repository, TracWikiPage page, String pageUrl) {
        this.repository = repository;
        this.page = page;
        this.pageUrl = pageUrl;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public void setRepository(TaskRepository repository) {
        this.repository = repository;
    }

    public TracWikiPage getPage() {
        return this.page;
    }

    public void setPage(TracWikiPage page) {
        this.page = page;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.page.getPageInfo().getPageName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return String.valueOf(this.getName()) + "  [" + this.repository.getRepositoryLabel() + "]";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IEditorInput.class) {
            return this;
        }
        if (adapter == IHistoryPageSource.class) {
            return historyPageSource;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TracWikiPageEditorInput other = (TracWikiPageEditorInput)obj;
        return this.repository.equals((Object)other.repository) && this.page.equals((Object)other.page);
    }
}

