/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.wiki;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.internal.trac.core.AbstractWikiHandler;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPageInfo;
import org.eclipse.mylyn.internal.trac.wiki.editor.TracWikiPageEditorInput;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.PlatformUI;

public class TracWikiPageHistoryPage
extends HistoryPage {
    private TableViewer viewer;

    public boolean inputSet() {
        if (this.getInput() instanceof TracWikiPageEditorInput) {
            this.refresh();
            return true;
        }
        return false;
    }

    public void createControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.setContentProvider((IContentProvider)new PageHistoryContentProvider());
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(80);
        column.getColumn().setText("Version");
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((TracWikiPageInfo)element).getVersion());
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(250);
        column.getColumn().setText("Date");
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TracWikiPageInfo)element).getLastModified().toString();
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText("Author");
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TracWikiPageInfo)element).getAuthor();
            }
        });
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText("Comment");
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TracWikiPageInfo)element).getComment();
            }
        });
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof TracWikiPageInfo && e2 instanceof TracWikiPageInfo) {
                    return ((TracWikiPageInfo)e2).getVersion() - ((TracWikiPageInfo)e1).getVersion();
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public String getDescription() {
        return "Change History for " + this.getName();
    }

    public String getName() {
        TracWikiPageEditorInput input = (TracWikiPageEditorInput)this.getInput();
        return String.valueOf(input.getPage().getPageInfo().getPageName()) + " [" + input.getRepository().getRepositoryLabel() + "]";
    }

    public boolean isValidInput(Object object) {
        if (object instanceof TracWikiPageEditorInput) {
            TracWikiPageEditorInput input = (TracWikiPageEditorInput)object;
            return input.getRepository() != null && input.getPage() != null;
        }
        return false;
    }

    public void refresh() {
        TracWikiPageEditorInput input = (TracWikiPageEditorInput)this.getInput();
        new DownloadPageHistoryJob(input.getRepository(), input.getPage()).schedule();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    class DownloadPageHistoryJob
    extends Job {
        private TaskRepository repository;
        private TracWikiPage page;

        public DownloadPageHistoryJob(TaskRepository repository, TracWikiPage page) {
            super("Download Page History");
            this.repository = repository;
            this.page = page;
        }

        protected IStatus run(IProgressMonitor monitor) {
            AbstractWikiHandler wikiHandler = TracCorePlugin.getDefault().getConnector().getWikiHandler();
            try {
                try {
                    monitor.beginTask("Retrieving wiki page history", -1);
                    final TracWikiPageInfo[] pageVersions = wikiHandler.getPageHistory(this.repository, this.page.getPageInfo().getPageName(), monitor);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TracWikiPageHistoryPage.this.viewer.setInput((Object)pageVersions);
                        }
                    });
                }
                catch (CoreException coreException) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TracWikiPageHistoryPage.this.viewer.setInput(null);
                        }
                    });
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }

    class PageHistoryContentProvider
    implements IStructuredContentProvider {
        PageHistoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (TracWikiPageInfo[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

