/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.wiki.editor;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.model.TracWikiPage;
import org.eclipse.mylyn.internal.trac.ui.editor.TracRenderingEngine;
import org.eclipse.mylyn.internal.trac.wiki.editor.TracWikiPageEditorInput;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.TaskTextViewerConfiguration;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class TracWikiPageEditor
extends FormEditor {
    public static final String ID_EDITOR = "org.eclipse.mylyn.trac.ui.editor.wikipage";
    private TaskRepository repository;
    private TracWikiPage page;
    private WikiSourceEditor wikiSourceEditor = new WikiSourceEditor(this);
    private BrowserFormPage browserPage = new BrowserFormPage(this, "Browser");

    protected void initializeEditor() {
        TracWikiPageEditorInput editorInput = (TracWikiPageEditorInput)this.getEditorInput();
        this.page = editorInput.getPage();
        this.repository = editorInput.getRepository();
    }

    protected void addPages() {
        this.initializeEditor();
        try {
            this.addPage((IFormPage)this.wikiSourceEditor);
            this.addPage((IFormPage)this.browserPage);
            this.setPartName(this.getEditorInput().getName());
            this.setActivePage("org.eclipse.mylyn.trac.ui.editor.wikibrowser");
        }
        catch (PartInitException e) {
            StatusHandler.fail((Throwable)e, (String)"Cannot create Trac Wiki page editor pages", (boolean)true);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Changes cannot be saved", (String)"Offline editting on wiki pages not supported yet.");
        monitor.setCanceled(true);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void updateWikiPage() {
        Job updatePageJob = new Job("Update wiki page"){

            protected IStatus run(IProgressMonitor monitor) {
                block6: {
                    try {
                        try {
                            monitor.beginTask("Downloading wiki page", -1);
                            TracWikiPage newPage = TracCorePlugin.getDefault().getConnector().getWikiHandler().getWikiPage(TracWikiPageEditor.this.repository, TracWikiPageEditor.this.page.getPageInfo().getPageName(), monitor);
                            if (newPage != null) {
                                ((TracWikiPageEditorInput)TracWikiPageEditor.this.getEditorInput()).setPage(newPage);
                                break block6;
                            }
                            StatusHandler.fail(null, (String)("Unable to retrieve wiki page " + TracWikiPageEditor.this.page.getPageInfo().getPageName()), (boolean)true, (int)4);
                        }
                        catch (CoreException e) {
                            StatusHandler.displayStatus((String)"Download failed", (IStatus)e.getStatus());
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        updatePageJob.schedule();
    }

    private class BrowserFormPage
    extends FormPage {
        public static final String ID_EDITOR = "org.eclipse.mylyn.trac.ui.editor.wikibrowser";
        private Browser browser;

        public BrowserFormPage(FormEditor editor, String title) {
            super(editor, ID_EDITOR, title);
        }

        protected void createFormContent(IManagedForm managedForm) {
            super.createFormContent(managedForm);
            try {
                TracWikiPageEditorInput editorInput = (TracWikiPageEditorInput)this.getEditorInput();
                ScrolledForm form = managedForm.getForm();
                form.getBody().setLayout((Layout)new FillLayout());
                this.browser = new Browser(form.getBody(), 0);
                managedForm.getForm().setContent((Control)this.browser);
                this.browser.setUrl(editorInput.getPageUrl());
            }
            catch (SWTError e) {
                StatusHandler.fail((Throwable)e, (String)("Could not create Browser page: " + e.getMessage()), (boolean)true);
            }
            catch (RuntimeException e) {
                StatusHandler.fail((Throwable)e, (String)"Could not create wiki page", (boolean)false);
            }
        }

        public void refresh() {
            this.browser.refresh();
        }

        public void dispose() {
            if (this.browser != null && !this.browser.isDisposed()) {
                this.browser.dispose();
            }
            super.dispose();
        }
    }

    private class WikiSourceEditor
    extends FormPage {
        private static final String ID = "org.eclipse.mylyn.trac.ui.editor.wikisource";
        private static final String TITLE = "Wiki Page Source";
        private static final String LABEL_PREVIEW = "Page Preview";
        private static final String LABEL_SOURCE = "Page Source";
        private static final String LABEL_BUTTON_PREVIEW = "Preview";
        private static final String LABEL_BUTTON_SUBMIT = "Submit";
        private static final int PREVIEW_BROWSER_HEIGHT = 140;
        private static final int DEFAULT_WIDTH = 553;
        private ScrolledForm form;
        private FormToolkit toolkit;
        private Composite editorComposite;
        private Section previewSection;
        private Browser previewBrowser;
        private TextViewer sourceEditor;
        private Button previewButton;
        private Button submitButton;
        protected boolean isDirty;
        private boolean ignoreLocationEvents;

        public WikiSourceEditor(FormEditor editor) {
            super(editor, ID, TITLE);
            this.ignoreLocationEvents = false;
        }

        protected void createFormContent(IManagedForm managedForm) {
            super.createFormContent(managedForm);
            this.form = managedForm.getForm();
            this.toolkit = managedForm.getToolkit();
            this.editorComposite = this.form.getBody();
            GridLayout editorLayout = new GridLayout();
            this.editorComposite.setLayout((Layout)editorLayout);
            this.editorComposite.setLayoutData((Object)new GridData(1808));
            this.createPreviewSection(this.editorComposite);
            this.createSourceSection(this.editorComposite);
        }

        private void createPreviewSection(Composite parent) {
            this.previewSection = this.toolkit.createSection(parent, 258);
            this.previewSection.setText(LABEL_PREVIEW);
            this.previewSection.setExpanded(false);
            this.previewSection.setLayout((Layout)new GridLayout());
            this.previewSection.setLayoutData((Object)new GridData(768));
            this.previewSection.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanging(ExpansionEvent e) {
                    WikiSourceEditor.this.form.reflow(true);
                }

                public void expansionStateChanged(ExpansionEvent e) {
                    WikiSourceEditor.this.form.reflow(true);
                }
            });
            Composite container = this.toolkit.createComposite((Composite)this.previewSection);
            this.previewSection.setClient((Control)container);
            container.setLayout((Layout)new GridLayout());
            container.setLayoutData((Object)new GridData(1808));
            this.previewBrowser = this.addBrowser(container, 0);
            this.previewBrowser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            GridData previewBrowserData = new GridData(1808);
            previewBrowserData.heightHint = 140;
            this.previewBrowser.setLayoutData((Object)previewBrowserData);
            this.toolkit.paintBordersFor(container);
        }

        private void createSourceSection(Composite parent) {
            Section section = this.toolkit.createSection(parent, 256);
            section.setText(LABEL_SOURCE);
            section.setExpanded(true);
            section.setLayout((Layout)new GridLayout());
            section.setLayoutData((Object)new GridData(1808));
            section.addExpansionListener(new IExpansionListener(){

                public void expansionStateChanging(ExpansionEvent e) {
                    WikiSourceEditor.this.form.reflow(true);
                }

                public void expansionStateChanged(ExpansionEvent e) {
                    WikiSourceEditor.this.form.reflow(true);
                }
            });
            Composite container = this.toolkit.createComposite((Composite)section);
            section.setClient((Control)container);
            container.setLayout((Layout)new GridLayout());
            container.setLayoutData((Object)new GridData(1808));
            this.sourceEditor = new SourceViewer(container, null, 8389186);
            this.sourceEditor.getControl().setLayoutData((Object)new GridData(1808));
            this.sourceEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            this.sourceEditor.setEditable(true);
            this.sourceEditor.getTextWidget().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!WikiSourceEditor.this.isDirty()) {
                        WikiSourceEditor.this.markDirty(true);
                        WikiSourceEditor.this.setSubmitEnabled(true);
                    }
                }
            });
            StyledText styledText = this.sourceEditor.getTextWidget();
            GridDataFactory.fillDefaults().hint(553, -1).grab(true, true).applyTo((Control)styledText);
            DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
            final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)((SourceViewer)this.sourceEditor), null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
            Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
            while (e.hasNext()) {
                support.setAnnotationPreference((AnnotationPreference)e.next());
            }
            support.install(EditorsUI.getPreferenceStore());
            styledText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    support.uninstall();
                }
            });
            TaskTextViewerConfiguration viewerConfig = new TaskTextViewerConfiguration(true);
            ((SourceViewer)this.sourceEditor).configure((SourceViewerConfiguration)viewerConfig);
            Document document = new Document(TracWikiPageEditor.this.page.getContent());
            ((SourceViewer)this.sourceEditor).setDocument((IDocument)document, (IAnnotationModel)new AnnotationModel());
            this.createActionsLayout(container);
            this.toolkit.paintBordersFor(container);
        }

        private void createActionsLayout(Composite parent) {
            Composite buttonComposite = this.toolkit.createComposite(parent);
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.numColumns = 2;
            buttonComposite.setLayout((Layout)buttonLayout);
            buttonComposite.setLayoutData((Object)new GridData(768));
            this.addActionButtons(buttonComposite);
        }

        private void addActionButtons(Composite buttonComposite) {
            this.previewButton = this.toolkit.createButton(buttonComposite, LABEL_BUTTON_PREVIEW, 0);
            GridData previewButtonData = new GridData(32);
            previewButtonData.widthHint = 100;
            this.previewButton.setLayoutData((Object)previewButtonData);
            this.previewButton.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    WikiSourceEditor.this.previewSection.setExpanded(true);
                    WikiSourceEditor.this.setText(WikiSourceEditor.this.previewBrowser, "loading preview...");
                    WikiSourceEditor.this.previewWiki(WikiSourceEditor.this.previewBrowser, WikiSourceEditor.this.sourceEditor.getTextWidget().getText());
                }
            });
            this.submitButton = this.toolkit.createButton(buttonComposite, LABEL_BUTTON_SUBMIT, 0);
            GridData submitButtonData = new GridData(32);
            submitButtonData.widthHint = 100;
            this.submitButton.setImage(TasksUiImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_SUBMIT));
            this.submitButton.setLayoutData((Object)submitButtonData);
            this.submitButton.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    InputDialog commentDialog = new InputDialog(null, "Page Comment", "Enter a Comment for the page (or cancel the submit):", null, null);
                    if (commentDialog.open() == 0) {
                        TracWikiPageEditor.this.page.getPageInfo().setComment(commentDialog.getValue());
                        TracWikiPageEditor.this.page.getPageInfo().setAuthor(TracWikiPageEditor.this.repository.isAnonymous() ? "anonymous" : TracWikiPageEditor.this.repository.getUserName());
                        TracWikiPageEditor.this.page.setContent(WikiSourceEditor.this.sourceEditor.getTextWidget().getText());
                        WikiSourceEditor.this.submitToRepository();
                    }
                }
            });
            this.setSubmitEnabled(false);
        }

        private void setSubmitEnabled(boolean enabled) {
            if (this.submitButton != null && !this.submitButton.isDisposed()) {
                this.submitButton.setEnabled(enabled);
                if (enabled) {
                    this.submitButton.setToolTipText("Submit to " + TracWikiPageEditor.this.repository.getUrl());
                }
            }
        }

        public void submitToRepository() {
            class SubmitPageJob
            extends Job {
                private IStatus jobStatus;

                public SubmitPageJob() {
                    super("upload wiki page");
                }

                public IStatus getStatus() {
                    return this.jobStatus;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask("Uploading wiki page", -1);
                            TracCorePlugin.getDefault().getConnector().getWikiHandler().postWikiPage(TracWikiPageEditor.this.repository, TracWikiPageEditor.this.page, monitor);
                            this.jobStatus = Status.OK_STATUS;
                        }
                        catch (CoreException e) {
                            StatusHandler.displayStatus((String)"Submit failed", (IStatus)e.getStatus());
                            this.jobStatus = e.getStatus();
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            }
            final SubmitPageJob submitJob = new SubmitPageJob();
            submitJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
                {
                }

                public void done(IJobChangeEvent event) {
                    if (submitJob.getStatus().isOK()) {
                        TracWikiPageEditor.this.updateWikiPage();
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TracWikiPageEditor.this.browserPage.refresh();
                                TracWikiPageEditor.this.setActivePage("org.eclipse.mylyn.trac.ui.editor.wikibrowser");
                                WikiSourceEditor.this.markDirty(false);
                                WikiSourceEditor.this.setSubmitEnabled(false);
                            }
                        });
                    }
                }
            });
            submitJob.schedule();
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        protected void markDirty(boolean dirty) {
            this.isDirty = dirty;
            this.getManagedForm().dirtyStateChanged();
        }

        private Browser addBrowser(Composite parent, int style) {
            Browser browser = new Browser(parent, style);
            browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changing(LocationEvent event) {
                    if (WikiSourceEditor.this.ignoreLocationEvents) {
                        return;
                    }
                    if (event.location != null) {
                        event.doit = false;
                    }
                }
            });
            return browser;
        }

        private void setText(Browser browser, String html) {
            try {
                this.ignoreLocationEvents = true;
                browser.setText(html != null ? html : "");
            }
            finally {
                this.ignoreLocationEvents = false;
            }
        }

        private void previewWiki(final Browser browser, String sourceText) {
            final class PreviewWikiJob
            extends Job {
                private String sourceText;
                private String htmlText;
                private IStatus jobStatus;

                public PreviewWikiJob(String sourceText) {
                    super("Formatting Wiki Text");
                    if (sourceText == null) {
                        throw new IllegalArgumentException("source text must not be null");
                    }
                    this.sourceText = sourceText;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    TracRenderingEngine htmlRenderingEngine = new TracRenderingEngine();
                    this.jobStatus = Status.OK_STATUS;
                    try {
                        this.htmlText = htmlRenderingEngine.renderAsHtml(TracWikiPageEditor.this.repository, this.sourceText, monitor);
                    }
                    catch (CoreException e) {
                        this.jobStatus = e.getStatus();
                    }
                    return Status.OK_STATUS;
                }

                public String getHtmlText() {
                    return this.htmlText;
                }

                public IStatus getStatus() {
                    return this.jobStatus;
                }
            }
            final PreviewWikiJob job = new PreviewWikiJob(sourceText);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
                {
                }

                public void done(IJobChangeEvent event) {
                    if (!WikiSourceEditor.this.form.isDisposed()) {
                        if (job.getStatus().isOK()) {
                            WikiSourceEditor.this.getPartControl().getDisplay().asyncExec(new Runnable(){
                                {
                                }

                                public void run() {
                                    WikiSourceEditor.this.setText(browser, job.getHtmlText());
                                }
                            });
                        } else {
                            WikiSourceEditor.this.getPartControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                }
                            });
                        }
                    }
                    super.done(event);
                }
            });
            job.setUser(true);
            job.schedule();
        }
    }
}

