/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.DefaultTaskSchema;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeTaskMapper {
    private final Map<String, String> attributes;

    public AttributeTaskMapper(Map<String, String> attributes) {
        Assert.isNotNull(attributes);
        this.attributes = attributes;
    }

    public boolean isMappingComplete() {
        return this.getTaskRepository() != null && this.attributes.get("product") != null;
    }

    public TaskRepository getTaskRepository() {
        TaskRepository taskRepository = null;
        String repositoryUrl = this.attributes.get("repositoryUrl");
        if (repositoryUrl != null) {
            String repositoryKind = this.attributes.get("repositoryKind");
            taskRepository = repositoryKind != null ? TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl) : TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl, repositoryKind);
        }
        return taskRepository;
    }

    public TaskSelection createTaskSelection() {
        TaskSelection selection = new TaskSelection("", "");
        this.applyTo(selection.getTaskData());
        return selection;
    }

    public void applyTo(RepositoryTaskData taskData) {
        DefaultTaskSchema schema = new DefaultTaskSchema(taskData);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if ("product".equals(entry.getKey())) {
                schema.setProduct(entry.getValue());
                continue;
            }
            if (!"component".equals(entry.getKey())) continue;
            schema.setComponent(entry.getValue());
        }
    }
}

