/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyValueParser {
    private final String text;
    private Map<String, String> pairs;
    private StringBuilder token;
    private boolean escaping;
    private Mode mode;
    private String key;

    public KeyValueParser(String text) {
        this.text = text;
    }

    public Map<String, String> parse() throws ParseException {
        this.init();
        int i = 0;
        while (i < this.text.length()) {
            char c = this.text.charAt(i);
            switch (c) {
                case '\\': {
                    if (this.escaping) {
                        this.append(c);
                        break;
                    }
                    this.escaping = true;
                    break;
                }
                case '=': {
                    if (this.escaping) {
                        this.append(c);
                        break;
                    }
                    if (this.mode == Mode.VALUE) {
                        throw new ParseException("Unexpected character '='", i);
                    }
                    this.key = this.token.toString();
                    this.token.setLength(0);
                    this.mode = Mode.VALUE;
                    break;
                }
                case ';': {
                    if (this.escaping) {
                        this.append(c);
                        break;
                    }
                    if (this.mode == Mode.KEY) {
                        throw new ParseException("Unexpected character ';'", i);
                    }
                    this.pairs.put(this.key, this.token.toString());
                    this.token.setLength(0);
                    this.mode = Mode.KEY;
                    break;
                }
                default: {
                    this.append(c);
                }
            }
            ++i;
        }
        if (this.mode == Mode.KEY) {
            throw new ParseException("Unexpected end of input", this.text.length());
        }
        this.pairs.put(this.key, this.token.toString());
        return Collections.unmodifiableMap(this.pairs);
    }

    private void append(char c) {
        this.escaping = false;
        this.token.append(c);
    }

    private void init() {
        this.pairs = new HashMap<String, String>();
        this.token = new StringBuilder();
        this.mode = Mode.KEY;
        this.escaping = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        KEY,
        VALUE;

    }
}

