/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.bugzilla.ide.AttributeTaskMapper;
import org.eclipse.mylyn.internal.bugzilla.ide.PluginRepositoryMappingManager;
import org.eclipse.mylyn.internal.bugzilla.ide.TaskContributorManager;
import org.eclipse.mylyn.monitor.core.AbstractErrorReporter;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskErrorReporter
extends AbstractErrorReporter {
    private PluginRepositoryMappingManager manager = new PluginRepositoryMappingManager();

    TaskErrorReporter() {
    }

    public boolean isEnabled() {
        return this.manager.hasMappings();
    }

    public int getPriority(IStatus status) {
        Assert.isNotNull((Object)status);
        String pluginId = status.getPlugin();
        int i = 0;
        while (i <= pluginId.length()) {
            if (this.manager.getMapping(pluginId.substring(0, i)) != null) {
                return PRIORITY_DEFAULT;
            }
            ++i;
        }
        return PRIORITY_NONE;
    }

    public void handle(IStatus status) {
        Assert.isNotNull((Object)status);
        String pluginId = status.getPlugin();
        Map<String, String> attributes = this.manager.getAllAttributes(pluginId);
        this.openNewTaskEditor(status, attributes);
    }

    private void openNewTaskEditor(IStatus status, Map<String, String> attributes) {
        AttributeTaskMapper mapper = new AttributeTaskMapper(attributes);
        TaskRepository taskRepository = mapper.getTaskRepository();
        try {
            RepositoryTaskData taskData;
            if (taskRepository != null && (taskData = this.createTaskData(taskRepository, mapper)) != null) {
                taskData.setSummary(status.getMessage());
                TaskContributorManager manager = new TaskContributorManager();
                manager.updateAttributes(taskData, status);
                String editorId = manager.getEditorId(status);
                NewTaskEditorInput editorInput = new NewTaskEditorInput(taskRepository, taskData);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                TasksUiUtil.openEditor((IEditorInput)editorInput, (String)editorId, (IWorkbenchPage)page);
                return;
            }
            TaskSelection taskSelection = mapper.createTaskSelection();
            this.updateAttributes(taskSelection.getTaskData(), status);
            TasksUiUtil.openNewTaskEditor(null, (TaskSelection)taskSelection, (TaskRepository)taskRepository);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private RepositoryTaskData createTaskData(final TaskRepository taskRepository, AttributeTaskMapper mapper) {
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(taskRepository.getConnectorKind());
        final AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        if (taskDataHandler == null) {
            return null;
        }
        AbstractAttributeFactory attributeFactory = taskDataHandler.getAttributeFactory(taskRepository.getUrl(), taskRepository.getConnectorKind(), "task");
        final RepositoryTaskData taskData = new RepositoryTaskData(attributeFactory, taskRepository.getConnectorKind(), taskRepository.getUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId());
        taskData.setNew(true);
        mapper.applyTo(taskData);
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (!taskDataHandler.initializeTaskData(taskRepository, taskData, monitor)) {
                            throw new InvocationTargetException(new Exception());
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        taskDataHandler.cloneTaskData(mapper.createTaskSelection().getTaskData(), taskData);
        return taskData;
    }

    private void updateAttributes(RepositoryTaskData taskData, IStatus status) {
    }
}

