/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.bugzilla.ide.BugzillaIdePlugin;
import org.eclipse.mylyn.internal.bugzilla.ide.PluginRepositoryMappingManager;
import org.eclipse.mylyn.internal.bugzilla.ide.wizards.FeatureStatus;
import org.eclipse.mylyn.internal.bugzilla.ide.wizards.SelectFeaturePage;
import org.eclipse.mylyn.internal.bugzilla.ide.wizards.SelectProductPage;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;

public class ReportBugWizard
extends Wizard {
    private SelectProductPage selectProductPage;
    private PluginRepositoryMappingManager manager;

    public ReportBugWizard() {
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle("Report Bug or Enhancement");
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void addPages() {
        this.manager = new PluginRepositoryMappingManager();
        this.selectProductPage = new SelectProductPage("selectBundleGroupProvider", this.manager);
        this.addPage((IWizardPage)this.selectProductPage);
    }

    public boolean canFinish() {
        return this.getSelectedBundleGroup() != null;
    }

    public IBundleGroup getSelectedBundleGroup() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof SelectProductPage) {
            if (page.isPageComplete() && !((SelectProductPage)page).canFlipToNextPage()) {
                return ((SelectProductPage)page).getSelectedBundleGroup();
            }
        } else if (page instanceof SelectFeaturePage && page.isPageComplete()) {
            return ((SelectFeaturePage)page).getSelectedBundleGroup();
        }
        return null;
    }

    public boolean performFinish() {
        final IBundleGroup bundle = this.getSelectedBundleGroup();
        Assert.isNotNull((Object)bundle);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                BugzillaIdePlugin.getTaskErrorReporter().handle((IStatus)new FeatureStatus(bundle));
            }
        });
        return true;
    }
}

