/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.bugzilla.ide.AttributeTaskMapper;
import org.eclipse.mylyn.internal.bugzilla.ide.PluginRepositoryMappingManager;
import org.eclipse.mylyn.internal.bugzilla.ide.wizards.SelectFeaturePage;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectProductPage
extends WizardPage {
    private static final int TABLE_HEIGHT = 300;
    private ImageRegistry imageRegistry;
    private final PluginRepositoryMappingManager manager;
    private BundleGroupContainer selectedBundleGroupContainer;

    public SelectProductPage(String pageName, PluginRepositoryMappingManager manager) {
        super(pageName);
        this.manager = manager;
        this.setTitle("Select a product");
    }

    public boolean canFlipToNextPage() {
        return this.selectedBundleGroupContainer != null && this.selectedBundleGroupContainer.requiresSelection();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        this.imageRegistry = new ImageRegistry(this.getShell().getDisplay());
        final Map<String, BundleGroupContainer> containerByName = this.getProducts();
        TableViewer viewer = new TableViewer(composite, 2820);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 300).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return containerByName.values().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof BundleGroupContainer) {
                    BundleGroupContainer product = (BundleGroupContainer)element;
                    return SelectProductPage.this.imageRegistry.get(product.getName());
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof BundleGroupContainer) {
                    BundleGroupContainer product = (BundleGroupContainer)element;
                    return product.getName();
                }
                return "";
            }
        });
        viewer.setInput((Object)TasksUiPlugin.getRepositoryManager().getRepositoryConnectors());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof BundleGroupContainer) {
                    SelectProductPage.this.selectedBundleGroupContainer = (BundleGroupContainer)selection.getFirstElement();
                    if (SelectProductPage.this.selectedBundleGroupContainer.requiresSelection()) {
                        SelectProductPage.this.setMessage(null);
                    } else {
                        SelectProductPage.this.setMessage(SelectProductPage.this.selectedBundleGroupContainer.getDisplayGroup().getDescription());
                    }
                    SelectProductPage.this.setPageComplete(true);
                } else {
                    SelectProductPage.this.setMessage(null);
                    SelectProductPage.this.setPageComplete(false);
                }
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (SelectProductPage.this.canFlipToNextPage()) {
                    SelectProductPage.this.getContainer().showPage(SelectProductPage.this.getNextPage());
                } else if (SelectProductPage.this.isPageComplete() && SelectProductPage.this.getWizard().performFinish()) {
                    ((WizardDialog)SelectProductPage.this.getContainer()).close();
                }
            }
        });
        viewer.getTable().showSelection();
        viewer.getTable().setFocus();
        viewer.setSorter(new ViewerSorter());
        this.setControl((Control)composite);
    }

    public void dispose() {
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
        }
        super.dispose();
    }

    public IWizardPage getNextPage() {
        if (this.canFlipToNextPage()) {
            SelectFeaturePage page = new SelectFeaturePage("selectBundle", this.getSelectedBundleGroups());
            page.setWizard(this.getWizard());
            return page;
        }
        return null;
    }

    private Map<String, BundleGroupContainer> getProducts() {
        HashMap<String, BundleGroupContainer> containerByName = new HashMap<String, BundleGroupContainer>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            IBundleGroupProvider[] iBundleGroupProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
                int n3 = iBundleGroupArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup bundleGroup = iBundleGroupArray[n4];
                    this.addProduct(containerByName, bundleGroup);
                    ++n4;
                }
                ++n2;
            }
        }
        return containerByName;
    }

    private void addProduct(Map<String, BundleGroupContainer> containerByName, IBundleGroup bundleGroup) {
        Map<String, String> attributes = this.manager.getAllAttributes(bundleGroup.getIdentifier());
        AttributeTaskMapper mapper = new AttributeTaskMapper(attributes);
        if (!mapper.isMappingComplete()) {
            return;
        }
        String imageUrl = bundleGroup.getProperty("featureImage");
        if (imageUrl == null) {
            return;
        }
        String productName = attributes.get("branding");
        if (productName == null) {
            productName = bundleGroup.getName();
        }
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(imageUrl));
            this.imageRegistry.put(productName, imageDescriptor);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        BundleGroupContainer container = containerByName.get(productName);
        if (container == null) {
            container = new BundleGroupContainer(productName, bundleGroup);
            containerByName.put(productName, container);
        } else {
            container.addBundleGroup(bundleGroup);
        }
    }

    public IBundleGroup getSelectedBundleGroup() {
        if (this.selectedBundleGroupContainer != null) {
            return this.selectedBundleGroupContainer.getGroups().get(0);
        }
        return null;
    }

    public IBundleGroup[] getSelectedBundleGroups() {
        if (this.selectedBundleGroupContainer != null) {
            return this.selectedBundleGroupContainer.getGroups().toArray(new IBundleGroup[0]);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleGroupContainer {
        private final IBundleGroup displayGroup;
        private final List<IBundleGroup> groups;
        private final String name;

        public BundleGroupContainer(String name, IBundleGroup displayGroup) {
            this.name = name;
            this.displayGroup = displayGroup;
            this.groups = new ArrayList<IBundleGroup>();
            this.groups.add(displayGroup);
        }

        public IBundleGroup getDisplayGroup() {
            return this.displayGroup;
        }

        public void addBundleGroup(IBundleGroup bundleGroup) {
            for (IBundleGroup group : this.groups) {
                if (!group.getName().equals(bundleGroup.getName())) continue;
                return;
            }
            this.groups.add(bundleGroup);
        }

        public List<IBundleGroup> getGroups() {
            return this.groups;
        }

        private String getName() {
            return this.name;
        }

        public boolean requiresSelection() {
            return this.groups.size() > 1;
        }
    }
}

