/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core.history;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.bugzilla.core.history.AttachmentFlag;
import org.eclipse.mylyn.internal.bugzilla.core.history.AttachmentFlagState;
import org.eclipse.mylyn.internal.bugzilla.core.history.AttachmentFlagStatus;
import org.eclipse.mylyn.internal.bugzilla.core.history.TaskRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentEvent
extends TaskRevision {
    private static final long serialVersionUID = 3258693199936631348L;
    private static final Pattern id = Pattern.compile("\\d+");
    private final int attachmentId;
    private List<AttachmentFlag> flags;

    public AttachmentEvent(int id, List<AttachmentFlag> flags) {
        this.what = "Attachment";
        this.attachmentId = id;
        this.flags = flags;
    }

    public String getFlagsString() {
        String flagString = "";
        for (AttachmentFlag flag : this.flags) {
            flagString = String.valueOf(flagString) + flag + " ";
        }
        return flagString;
    }

    public static int parseId(String attachment) {
        Matcher matcher = id.matcher(attachment);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        System.err.println("WARNING: Cannot find attachment id in " + attachment);
        return -1;
    }

    public static List<AttachmentFlag> parseFlags(String attachmentFlags) {
        ArrayList<AttachmentFlag> flags = new ArrayList<AttachmentFlag>();
        AttachmentFlagStatus flagStatus = AttachmentFlagStatus.UNKNOWN;
        AttachmentFlagState flagState = AttachmentFlagState.UNKNOWN;
        String[] flagToken = attachmentFlags.split(", ");
        int i = 0;
        while (i < flagToken.length) {
            String token = flagToken[i];
            if (token.indexOf("(") != -1) {
                String substr;
                int end = token.indexOf("(");
                token = substr = token.substring(0, end);
            }
            if (token.startsWith("needs-work")) {
                flags.add(new AttachmentFlag(AttachmentFlagStatus.REVIEW, AttachmentFlagState.DENIED));
                flags.add(new AttachmentFlag(AttachmentFlagStatus.SUPERREVIEW, AttachmentFlagState.DENIED));
            } else {
                boolean firstOrSecondReview;
                boolean startsWithReview = token.toLowerCase().startsWith(AttachmentFlagStatus.REVIEW.name().toLowerCase());
                boolean bl = firstOrSecondReview = token.toLowerCase().contains(AttachmentFlagStatus.REVIEW.name().toLowerCase()) && (token.toLowerCase().startsWith("first-") || token.toLowerCase().startsWith("second-"));
                if (startsWithReview || firstOrSecondReview) {
                    flagStatus = AttachmentFlagStatus.REVIEW;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.SUPERREVIEW.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.SUPERREVIEW;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.APPROVAL.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.APPROVAL;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.UI.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.UI;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.BRANCH.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.BRANCH;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.COMMITTED.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.COMMITTED;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.ACCEPTED.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.ACCEPTED;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.COMMENTED.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.COMMENTED;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.NONE.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.NONE;
                } else if (token.toLowerCase().startsWith(AttachmentFlagStatus.REJECTED.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.REJECTED;
                } else if (token.equals("1") || token.toLowerCase().startsWith(AttachmentFlagStatus.OBSOLETE.name().toLowerCase())) {
                    flagStatus = AttachmentFlagStatus.OBSOLETE;
                }
                if (flagStatus.equals((Object)AttachmentFlagStatus.UNKNOWN) && !token.equals("")) {
                    System.err.println("WARNING: Attachment flag status unknown: " + token);
                }
                if (token.length() > 0) {
                    if (token.charAt(token.length() - 1) == '?') {
                        flagState = AttachmentFlagState.REQUESTED;
                    } else if (token.charAt(token.length() - 1) == '+') {
                        flagState = AttachmentFlagState.GRANTED;
                    } else if (token.charAt(token.length() - 1) == '-') {
                        flagState = AttachmentFlagState.DENIED;
                    } else if (flagStatus.equals((Object)AttachmentFlagStatus.OBSOLETE) || flagStatus.equals((Object)AttachmentFlagStatus.COMMITTED) || flagStatus.equals((Object)AttachmentFlagStatus.ACCEPTED) || flagStatus.equals((Object)AttachmentFlagStatus.COMMENTED) || flagStatus.equals((Object)AttachmentFlagStatus.NONE) || flagStatus.equals((Object)AttachmentFlagStatus.REJECTED) || flagStatus.equals((Object)AttachmentFlagStatus.REVIEW)) {
                        flagState = AttachmentFlagState.OFF;
                    }
                }
                if (flagState.equals((Object)AttachmentFlagState.UNKNOWN) && !token.equals("")) {
                    System.err.println("WARNING: Attachment flag state unknown: " + token);
                }
                flags.add(new AttachmentFlag(flagStatus, flagState));
            }
            ++i;
        }
        return flags;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " | " + this.getDate() + " | " + this.getWhat() + " | " + this.attachmentId + " | " + this.getFlagsString();
    }

    public List<AttachmentFlag> getFlags() {
        return this.flags;
    }

    public int getAttachmentId() {
        return this.attachmentId;
    }
}

