/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.ide.KeyValueParser;
import org.eclipse.mylyn.internal.bugzilla.ide.PluginRepositoryMapping;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRepositoryMappingManager {
    private static final String EXTENSION_ID_PLUGIN_REPOSITORY_MAPPING = "org.eclipse.mylyn.bugzilla.ide.pluginRepositoryMappings";
    private static final String ELEMENT_MAPPING = "mapping";
    private static final String ELEMENT_MAPPING_ATTRIBUTES = "attributes";
    private static final String ATTRIBUTE_PLUGID_ID_PREFIX = "pluginIdPrefix";
    private TreeMap<String, PluginRepositoryMapping> mappingByPrefix;

    public PluginRepositoryMappingManager() {
        this.readExtensions();
    }

    private void readMapping(IConfigurationElement element) {
        IConfigurationElement[] attributeElements;
        String pluginIdPrefix = element.getAttribute(ATTRIBUTE_PLUGID_ID_PREFIX);
        Map<String, String> attributes = null;
        IConfigurationElement[] iConfigurationElementArray = attributeElements = element.getChildren(ELEMENT_MAPPING_ATTRIBUTES);
        int n = attributeElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement attributeElement = iConfigurationElementArray[n2];
            String repositoryAttributes = attributeElement.getValue();
            try {
                KeyValueParser parser = new KeyValueParser(repositoryAttributes);
                attributes = parser.parse();
            }
            catch (ParseException e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla.ide", "Invalid attributes in extension.", (Throwable)e));
                return;
            }
            ++n2;
        }
        if (attributes != null) {
            PluginRepositoryMapping pluginRepositoryMapping = new PluginRepositoryMapping();
            pluginRepositoryMapping.addAttributes(attributes);
            pluginRepositoryMapping.addPrefix(pluginIdPrefix);
            this.addPluginRepositoryMapping(pluginRepositoryMapping);
        } else {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla.ide", "Missing attributes in extension."));
        }
    }

    private void addPluginRepositoryMapping(PluginRepositoryMapping pluginRepositoryMapping) {
        List<String> prefixs = pluginRepositoryMapping.getPrefixes();
        for (String prefix : prefixs) {
            this.mappingByPrefix.put(prefix, pluginRepositoryMapping);
        }
    }

    private synchronized void readExtensions() {
        IExtension[] extensions;
        this.mappingByPrefix = new TreeMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_PLUGIN_REPOSITORY_MAPPING);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(ELEMENT_MAPPING)) {
                    this.readMapping(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public PluginRepositoryMapping getMapping(String prefix) {
        return this.mappingByPrefix.get(prefix);
    }

    public String getAttribute(String prefix, String key) {
        int i = prefix.length() - 1;
        while (i >= 0) {
            String value;
            PluginRepositoryMapping mapping = this.getMapping(prefix.substring(0, i));
            if (mapping != null && (value = mapping.getAttributes().get(key)) != null) {
                return value;
            }
            --i;
        }
        return null;
    }

    public Map<String, String> getAllAttributes(String prefix) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int i = 0;
        while (i <= prefix.length()) {
            PluginRepositoryMapping mapping = this.getMapping(prefix.substring(0, i));
            if (mapping != null) {
                attributes.putAll(mapping.getAttributes());
            }
            ++i;
        }
        return attributes;
    }

    public boolean hasMappings() {
        return !this.mappingByPrefix.isEmpty();
    }
}

