/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.ui.TaskFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractNewRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.search.SearchHitCollector;

public class StackTraceDuplicateDetector
extends AbstractDuplicateDetector {
    private static final int DESCRIPTION_MAX_CHARS = 6000;
    private static final String NO_STACK_MESSAGE = "Unable to locate a stack trace in the description text.";

    public SearchHitCollector getSearchHitCollector(TaskRepository repository, RepositoryTaskData taskData) {
        String queryUrl = "";
        String searchString = AbstractNewRepositoryTaskEditor.getStackTraceFromDescription((String)taskData.getDescription());
        if (searchString != null && searchString.length() > 6000) {
            searchString = searchString.substring(0, 6000);
        }
        if (searchString == null) {
            MessageDialog.openWarning(null, (String)"No Stack Trace Found", (String)NO_STACK_MESSAGE);
            return null;
        }
        try {
            queryUrl = String.valueOf(repository.getUrl()) + "/buglist.cgi?long_desc_type=allwordssubstr&long_desc=" + URLEncoder.encode(searchString, repository.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla.ide", "Error during duplicate detection", (Throwable)e));
            return null;
        }
        queryUrl = String.valueOf(queryUrl) + "&product=" + taskData.getProduct();
        BugzillaRepositoryQuery bugzillaQuery = new BugzillaRepositoryQuery(repository.getUrl(), queryUrl, "search");
        SearchHitCollector collector = new SearchHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), repository, (AbstractRepositoryQuery)bugzillaQuery, (ITaskFactory)new TaskFactory(repository, false, false));
        return collector;
    }
}

