/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.bugzilla.ide.BugzillaIdePlugin;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.log.LogEntry;

public class NewTaskFromErrorAction
implements IObjectActionDelegate {
    public static final String ID = "org.eclipse.mylyn.tasklist.ui.repositories.actions.create";
    private LogEntry entry;

    private void buildDescriptionFromLogEntry(LogEntry entry, StringBuilder sb, boolean includeChildren) {
        sb.append("\n\n-- Error Log --\nDate: ");
        sb.append(entry.getDate());
        sb.append("\nMessage: ");
        sb.append(entry.getMessage());
        sb.append("\nSeverity: " + entry.getSeverityText());
        sb.append("\nPlugin ID: ");
        sb.append(entry.getPluginId());
        sb.append("\nStack Trace:\n");
        if (entry.getStack() == null) {
            sb.append("no stack trace available");
        } else {
            sb.append(entry.getStack());
        }
        if (includeChildren && entry.hasChildren()) {
            Object[] children;
            Object[] objectArray = children = entry.getChildren(null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof LogEntry) {
                    this.buildDescriptionFromLogEntry((LogEntry)child, sb, includeChildren);
                }
                ++n2;
            }
        }
    }

    private void createTask(LogEntry entry) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        boolean includeChildren = false;
        if (entry.hasChildren() && MessageDialog.openQuestion((Shell)shell, (String)"Report Bug", (String)"Include children of this entry in the report?")) {
            includeChildren = true;
        }
        StringBuilder sb = new StringBuilder();
        this.buildDescriptionFromLogEntry(entry, sb, includeChildren);
        if (BugzillaIdePlugin.getTaskErrorReporter().isEnabled()) {
            Status status = new Status(entry.getSeverity(), entry.getPluginId(), entry.getMessage());
            BugzillaIdePlugin.getTaskErrorReporter().handle((IStatus)status);
        } else {
            TaskSelection taskSelection = new TaskSelection("", sb.toString());
            TasksUiUtil.openNewTaskEditor((Shell)shell, (TaskSelection)taskSelection, null);
        }
    }

    public void run() {
        this.createTask(this.entry);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object instanceof LogEntry) {
            this.entry = (LogEntry)object;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

