/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class BugzillaUiExtensionReader {
    public static final String EXTENSION_LANGUAGES = "org.eclipse.mylyn.bugzilla.core.languages";
    public static final String EXTENSION_TMPL_LANGUAGE = "language";
    public static final String ATTR_LANG_VALUE = "value";
    public static final String ELMNT_LANG_NAME = "name";
    public static final String ELMNT_LANG_ERROR_LOGIN = "error_login";
    public static final String ELMNT_LANG_ERROR_COLLISION = "error_collision";
    public static final String ELMNT_LANG_ERROR_COMMENT_REQIRED = "error_comment_required";
    public static final String ELMNT_LANG_ERROR_LOGGED_OUT = "error_logged_out";
    public static final String ELMNT_LANG_BAD_LOGIN = "bad_login";
    public static final String ELMNT_LANG_PROCESSED = "processed";
    public static final String ELMNT_LANG_CHANGES_SUBMITTED = "changes_submitted";
    private static boolean coreExtensionsRead = false;

    public static void initStartupExtensions() {
        if (!coreExtensionsRead) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint templatesExtensionPoint = registry.getExtensionPoint(EXTENSION_LANGUAGES);
            IExtension[] templateExtensions = templatesExtensionPoint.getExtensions();
            int i = 0;
            while (i < templateExtensions.length) {
                IConfigurationElement[] elements = templateExtensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(EXTENSION_TMPL_LANGUAGE)) {
                        BugzillaUiExtensionReader.readLanguageTemplate(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
            coreExtensionsRead = true;
        }
    }

    private static void readLanguageTemplate(IConfigurationElement element) {
        String languageName = element.getAttribute(ELMNT_LANG_NAME);
        if (languageName != null) {
            BugzillaRepositoryConnector connector = (BugzillaRepositoryConnector)TasksUiPlugin.getRepositoryManager().getRepositoryConnector("bugzilla");
            BugzillaLanguageSettings bugzillaLanguageSettings = new BugzillaLanguageSettings(languageName);
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String name = configElement.getName();
                if (name != null && name.equals("languageAttribute")) {
                    String command = configElement.getAttribute("command");
                    String response = configElement.getAttribute("response");
                    bugzillaLanguageSettings.addLanguageAttribute(command, response);
                }
                ++n2;
            }
            connector.addLanguageSetting(bugzillaLanguageSettings);
        } else {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.bugzilla.ui", "Could not load language template extension " + element.getName()));
        }
    }
}

