/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.context.ui.actions.ContextAttachAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextClearAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextCopyAction;
import org.eclipse.mylyn.internal.context.ui.actions.ContextRetrieveAction;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextMenuContributor
implements IDynamicSubMenuContributor {
    private static final String LABEL = "Context";

    public MenuManager getSubMenuManager(List<AbstractTaskContainer> selectedElements) {
        MenuManager subMenuManager = new MenuManager(LABEL);
        subMenuManager.setVisible(selectedElements.size() == 1 && selectedElements.get(0) instanceof AbstractTask);
        AbstractTask task = (AbstractTask)selectedElements.get(0);
        StructuredSelection selection = new StructuredSelection((Object)task);
        if (!task.isLocal()) {
            ContextAttachAction attachAction = new ContextAttachAction();
            attachAction.selectionChanged((IAction)attachAction, (ISelection)selection);
            subMenuManager.add((IAction)attachAction);
            ContextRetrieveAction retrieveAction = new ContextRetrieveAction();
            retrieveAction.selectionChanged((IAction)retrieveAction, (ISelection)selection);
            subMenuManager.add((IAction)retrieveAction);
        }
        ContextCopyAction copyAction = new ContextCopyAction();
        copyAction.selectionChanged((IAction)copyAction, (ISelection)selection);
        subMenuManager.add((IAction)copyAction);
        ContextClearAction clearAction = new ContextClearAction();
        clearAction.selectionChanged((IAction)clearAction, (ISelection)selection);
        subMenuManager.add((IAction)clearAction);
        return subMenuManager;
    }

    public String handleAcceleratorKeys(String text) {
        if (text == null) {
            return null;
        }
        int index = text.lastIndexOf(9);
        if (index == -1) {
            index = text.lastIndexOf(64);
        }
        if (index >= 0) {
            return text.concat("@");
        }
        return text;
    }
}

