/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.ide.ant;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.outline.AntEditorContentOutlinePage;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.internal.ide.ui.IdeUiBridgePlugin;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntUiBridge
extends AbstractContextUiBridge {
    public void open(IInteractionElement node) {
        String handle = node.getHandleIdentifier();
        int first = handle.indexOf(";");
        String filename = "";
        filename = first == -1 ? handle : handle.substring(0, first);
        try {
            Path path = new Path(filename);
            IFile f = (IFile)((Workspace)ResourcesPlugin.getWorkspace()).newResource((IPath)path, 1);
            IEditorPart editor = this.openInEditor(f, true);
            if (editor == null) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.ide.ant", "Unable to open editor for file: " + filename));
                return;
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.ide.ant", "Could not open XML editor", (Throwable)e));
        }
    }

    private IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = IdeUiBridgePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && file.exists()) {
            try {
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
                return editorPart;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void close(IInteractionElement node) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference reference = iEditorReferenceArray[n2];
                try {
                    IFileEditorInput input;
                    if (reference.getEditorInput() instanceof IFileEditorInput && (input = (IFileEditorInput)reference.getEditorInput()).getFile().getFullPath().toString().equals(node.getHandleIdentifier())) {
                        toClose.add(reference);
                    }
                }
                catch (PartInitException partInitException) {}
                ++n2;
            }
            if (toClose.size() > 0) {
                page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
            }
        }
    }

    public boolean acceptsEditor(IEditorPart editorPart) {
        return editorPart instanceof AntEditor;
    }

    public List<TreeViewer> getContentOutlineViewers(IEditorPart editor) {
        ArrayList<TreeViewer> viewers = new ArrayList<TreeViewer>();
        if (editor instanceof AntEditor) {
            try {
                AntEditor ae = (AntEditor)editor;
                AntEditorContentOutlinePage outline = (AntEditorContentOutlinePage)ae.getAdapter(IContentOutlinePage.class);
                Class<ContentOutlinePage> clazz = ContentOutlinePage.class;
                Method method = clazz.getDeclaredMethod("getTreeViewer", new Class[0]);
                method.setAccessible(true);
                viewers.add((TreeViewer)method.invoke((Object)outline, new Object[0]));
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.ide.ant", "Unable to get outline", (Throwable)e));
            }
        }
        return viewers;
    }

    public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
        return null;
    }

    public IInteractionElement getElement(IEditorInput input) {
        return null;
    }

    public String getContentType() {
        return "build.xml";
    }
}

