/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.core.AbstractAttributeMapper;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;

public class DefaultTaskSchema {
    private final RepositoryTaskData taskData;

    public DefaultTaskSchema(RepositoryTaskData taskData) {
        Assert.isNotNull((Object)taskData);
        this.taskData = taskData;
    }

    public String getComponent() {
        return this.getValue("task.common.component");
    }

    public Date getDateCreated() {
        return this.getDateValue("task.common.date.created");
    }

    public Date getDateModified() {
        return this.getDateValue("task.common.date.modified");
    }

    private Date getDateValue(String attributeKey) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute != null) {
            return this.taskData.getAttributeFactory().getAttributeMapper().getDateValue(attribute);
        }
        return null;
    }

    public String getDescription() {
        return this.getValue("task.common.description");
    }

    public String getOwner() {
        return this.getValue("task.common.user.owner");
    }

    public AbstractTask.PriorityLevel getPriority() {
        return AbstractTask.PriorityLevel.fromString(this.getValue("task.common.priority"));
    }

    public String getProduct() {
        return this.getValue("task.common.product");
    }

    public String getSummary() {
        return this.getValue("task.common.summary");
    }

    private String getValue(String attributeKey) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute != null) {
            return this.taskData.getAttributeFactory().getAttributeMapper().getValue(attribute);
        }
        return null;
    }

    public void setComponent(String component) {
        this.setValue("task.common.component", component);
    }

    public void setDateCreated(Date dateCreated) {
        this.setDateValue("task.common.date.created", dateCreated);
    }

    private RepositoryTaskAttribute setDateValue(String attributeKey, Date value) {
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute == null) {
            attribute = new RepositoryTaskAttribute(attributeKey, null, false);
            this.taskData.addAttribute(attributeKey, attribute);
        }
        this.taskData.getAttributeFactory().getAttributeMapper().setDateValue(attribute, value);
        return attribute;
    }

    public void setDescription(String description) {
        this.setValue("task.common.description", description);
    }

    public void setOwner(String owner) {
        this.setValue("task.common.user.owner", owner);
    }

    public void setPriority(AbstractTask.PriorityLevel priority) {
        this.setValue("task.common.priority", priority.toString());
    }

    public void setProduct(String product) {
        this.setValue("task.common.product", product);
    }

    public void setReporter(String reporter) {
        this.setValue("task.common.user.reporter", reporter);
    }

    public void setSummary(String summary) {
        this.setValue("task.common.summary", summary);
    }

    private RepositoryTaskAttribute setValue(String attributeKey, String value) {
        AbstractAttributeMapper attributeMapper;
        RepositoryTaskAttribute attribute = this.taskData.getAttribute(attributeKey);
        if (attribute == null) {
            attribute = new RepositoryTaskAttribute(attributeKey, null, false);
            this.taskData.addAttribute(attributeKey, attribute);
        }
        if ((attributeMapper = this.taskData.getAttributeFactory().getAttributeMapper()) != null) {
            attributeMapper.setValue(attribute, value);
        } else {
            attribute.setValue(value);
        }
        return attribute;
    }
}

