/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.ITaskDataStorage;
import org.eclipse.mylyn.internal.tasks.core.TaskDataState;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataManager {
    private final TaskRepositoryManager taskRepositoryManager;
    private final ITaskDataStorage storage;
    private int nextNewId = 1;

    public TaskDataManager(TaskRepositoryManager taskRepositoryManager, ITaskDataStorage storage) {
        this.taskRepositoryManager = taskRepositoryManager;
        this.storage = storage;
    }

    public void setNewTaskData(RepositoryTaskData data) {
        if (data == null || data.getRepositoryUrl() == null || data.getId() == null) {
            return;
        }
        TaskDataState state = this.retrieveState(data);
        if (state != null) {
            state.setNewTaskData(data);
        } else {
            state = new TaskDataState(data.getRepositoryUrl(), data.getId());
            state.setNewTaskData(data);
        }
        this.saveState(state);
    }

    public void setNewTaskData(String repositoryUrl, String taskId, RepositoryTaskData data) {
        TaskDataState state = this.retrieveState(repositoryUrl, taskId);
        if (state != null) {
            state.setNewTaskData(data);
        } else {
            state = new TaskDataState(repositoryUrl, taskId);
            state.setNewTaskData(data);
        }
        this.saveState(state);
    }

    public void setOldTaskData(RepositoryTaskData data) {
        if (data == null || data.getRepositoryUrl() == null || data.getId() == null) {
            return;
        }
        TaskDataState state = this.retrieveState(data);
        if (state != null) {
            state.setOldTaskData(data);
        } else {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Attempt to save old data when no new data exists", (Throwable)new Exception()));
        }
        this.saveState(state);
    }

    public RepositoryTaskData getNewTaskData(String repositoryUrl, String id) {
        if (repositoryUrl == null || id == null) {
            return null;
        }
        TaskDataState state = this.retrieveState(repositoryUrl, id);
        if (state != null) {
            return state.getNewTaskData();
        }
        return null;
    }

    public RepositoryTaskData getOldTaskData(String repositoryUrl, String id) {
        if (repositoryUrl == null || id == null) {
            return null;
        }
        TaskDataState state = this.retrieveState(repositoryUrl, id);
        if (state != null) {
            return state.getOldTaskData();
        }
        return null;
    }

    public synchronized String getNewRepositoryTaskId() {
        ++this.nextNewId;
        if (this.nextNewId == Integer.MAX_VALUE) {
            this.nextNewId = 1;
        }
        return "" + this.nextNewId;
    }

    public RepositoryTaskData getEditableCopy(String repositoryUrl, String id) {
        if (repositoryUrl == null || id == null) {
            return null;
        }
        TaskDataState state = this.retrieveState(repositoryUrl, id);
        RepositoryTaskData clone = null;
        if (state != null) {
            if (state.getNewTaskData() != null) {
                try {
                    clone = (RepositoryTaskData)ObjectCloner.deepCopy(state.getNewTaskData());
                    this.updateAttributeFactory(clone);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error constructing modifiable task", (Throwable)e));
                    return null;
                }
            }
            if (clone != null) {
                for (RepositoryTaskAttribute attribute : state.getEdits()) {
                    if (attribute == null) continue;
                    RepositoryTaskAttribute existing = clone.getAttribute(attribute.getId());
                    if (existing != null) {
                        existing.clearValues();
                        List<String> options = existing.getOptions();
                        for (String value : attribute.getValues()) {
                            if (options.size() > 0) {
                                if (!options.contains(value)) continue;
                                existing.addValue(value);
                                continue;
                            }
                            existing.addValue(value);
                        }
                        continue;
                    }
                    clone.addAttribute(attribute.getId(), attribute);
                }
            }
        }
        return clone;
    }

    public void saveEdits(String repositoryUrl, String id, Set<RepositoryTaskAttribute> changedAttributes) {
        TaskDataState state = this.retrieveState(repositoryUrl, id);
        if (state != null) {
            Set<RepositoryTaskAttribute> edits = state.getEdits();
            if (edits == null) {
                state.setEdits(changedAttributes);
            } else {
                edits.removeAll(changedAttributes);
                edits.addAll(changedAttributes);
            }
            try {
                this.storage.put(state);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error saving edits", (Throwable)e));
            }
        }
    }

    public Set<RepositoryTaskAttribute> getEdits(String repositoryUrl, String id) {
        if (repositoryUrl == null || id == null) {
            return Collections.emptySet();
        }
        TaskDataState state = this.retrieveState(repositoryUrl, id);
        if (state != null && state.getEdits() != null) {
            return Collections.unmodifiableSet(state.getEdits());
        }
        return Collections.emptySet();
    }

    public void discardEdits(String repositoryUrl, String id) {
        if (repositoryUrl == null || id == null) {
            return;
        }
        TaskDataState state = this.retrieveState(repositoryUrl, id);
        if (state != null) {
            state.discardEdits();
            try {
                this.storage.put(state);
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error discarding edits", (Throwable)e));
            }
        }
    }

    public void remove(String repositoryUrl, String id) {
        if (repositoryUrl == null || id == null) {
            return;
        }
        this.storage.remove(repositoryUrl, id);
    }

    public void clear() {
        this.nextNewId = 0;
        this.storage.clear();
    }

    private void updateAttributeFactory(RepositoryTaskData taskData) {
        AbstractAttributeFactory factory;
        if (taskData == null) {
            return;
        }
        taskData.refresh();
        AbstractRepositoryConnector connector = this.taskRepositoryManager.getRepositoryConnector(taskData.getRepositoryKind());
        if (connector != null && connector.getTaskDataHandler() != null && (factory = connector.getTaskDataHandler().getAttributeFactory(taskData)) != null) {
            taskData.setAttributeFactory(factory);
        }
    }

    public void start() {
        try {
            this.storage.start();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Offline storage start failed", (Throwable)e));
        }
    }

    public void stop() {
        try {
            this.storage.stop();
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Offline storage stop failed", (Throwable)e));
        }
    }

    public void saveNow() {
        this.storage.flush();
    }

    private TaskDataState retrieveState(RepositoryTaskData data) {
        return this.retrieveState(data.getRepositoryUrl(), data.getId());
    }

    private TaskDataState retrieveState(String repositoryUrl, String id) {
        TaskDataState state = null;
        try {
            state = this.storage.get(repositoryUrl, id);
            if (state != null) {
                if (state.getNewTaskData() != null) {
                    this.updateAttributeFactory(state.getNewTaskData());
                }
                if (state.getOldTaskData() != null) {
                    this.updateAttributeFactory(state.getOldTaskData());
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error saving offline data", (Throwable)e));
        }
        return state;
    }

    private void saveState(TaskDataState state) {
        this.storage.put(state);
    }

    public static class ObjectCloner {
        private ObjectCloner() {
        }

        public static Object deepCopy(Object oldObj) throws Exception {
            ObjectOutputStream outputStream = null;
            ObjectInputStream inputStream = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = new ObjectOutputStream(byteArrayOutputStream);
                outputStream.writeObject(oldObj);
                outputStream.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                inputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = inputStream.readObject();
                return object;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }
}

