/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticatedProxy;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.eclipse.mylyn.web.core.WebCorePlugin;

public class TaskRepositoryLocation
extends AbstractWebLocation {
    protected final TaskRepository taskRepository;

    public TaskRepositoryLocation(TaskRepository taskRepository) {
        super(taskRepository.getUrl());
        this.taskRepository = taskRepository;
    }

    public Proxy getProxyForHost(String host, String proxyType) {
        IProxyData data;
        if (!this.taskRepository.isDefaultProxyEnabled()) {
            return this.taskRepository.getProxy();
        }
        IProxyService service = WebCorePlugin.getProxyService();
        if (service != null && service.isProxiesEnabled() && (data = service.getProxyDataForHost(host, proxyType)) != null && data.getHost() != null) {
            String proxyHost = data.getHost();
            int proxyPort = data.getPort();
            if (proxyPort == -1) {
                proxyPort = 0;
            }
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
            if (data.isRequiresAuthentication()) {
                return new AuthenticatedProxy(this.getJavaProxyType(proxyType), (SocketAddress)sockAddr, data.getUserId(), data.getPassword());
            }
            return new Proxy(this.getJavaProxyType(proxyType), sockAddr);
        }
        return null;
    }

    private Proxy.Type getJavaProxyType(String type) {
        return "SOCKS".equals(type) ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
    }

    public AbstractWebLocation.ResultType requestCredentials(AuthenticationType type, String message) {
        return AbstractWebLocation.ResultType.NOT_SUPPORTED;
    }

    public AuthenticationCredentials getCredentials(AuthenticationType type) {
        return this.taskRepository.getCredentials(type);
    }
}

