/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
extends AbstractTaskContainer {
    public static final String DEFAULT_TASK_KIND = "task";
    private String repositoryUrl;
    private String taskKind = "task";
    private String taskId;
    private String owner;
    private boolean active = false;
    private String summary;
    private String priority = PriorityLevel.getDefault().toString();
    private boolean completed;
    private boolean isNotifiedIncoming = false;
    private boolean reminded = false;
    private boolean floatingScheduledDate = false;
    private String categoryHandle = "";
    private Set<AbstractTaskContainer> containers = new HashSet<AbstractTaskContainer>();
    private String lastReadTimeStamp;
    private boolean synchronizing;
    private boolean submitting;
    private RepositoryTaskSyncState synchronizationState = RepositoryTaskSyncState.SYNCHRONIZED;
    private IStatus synchronizationStatus = null;
    private boolean stale = false;
    private Date completionDate = null;
    private Date creationDate = null;
    private Date scheduledForDate = null;
    private Date dueDate = null;
    private String notes = "";
    private int estimatedTimeHours = 1;

    public AbstractTask(String repositoryUrl, String taskId, String summary) {
        super(RepositoryTaskHandleUtil.getHandle(repositoryUrl, taskId));
        this.repositoryUrl = repositoryUrl;
        this.taskId = taskId;
        this.summary = summary;
        this.url = "";
    }

    @Override
    public final String getHandleIdentifier() {
        return super.getHandleIdentifier();
    }

    public abstract boolean isLocal();

    public abstract String getConnectorKind();

    public String getLastReadTimeStamp() {
        return this.lastReadTimeStamp;
    }

    public void setLastReadTimeStamp(String lastReadTimeStamp) {
        this.lastReadTimeStamp = lastReadTimeStamp;
    }

    public void setSynchronizationState(RepositoryTaskSyncState syncState) {
        this.synchronizationState = syncState;
    }

    public RepositoryTaskSyncState getSynchronizationState() {
        return this.synchronizationState;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean sychronizing) {
        this.synchronizing = sychronizing;
    }

    public boolean isNotified() {
        return this.isNotifiedIncoming;
    }

    public void setNotified(boolean notified) {
        this.isNotifiedIncoming = notified;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public IStatus getSynchronizationStatus() {
        return this.synchronizationStatus;
    }

    public void setSynchronizationStatus(IStatus status) {
        this.synchronizationStatus = status;
    }

    public final String getTaskId() {
        return this.taskId;
    }

    public final String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    public final void setHandleIdentifier(String handleIdentifier) {
        throw new RuntimeException("Cannot set the handle identifier of a task, set repository URL instead.");
    }

    public final void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        super.setHandleIdentifier(RepositoryTaskHandleUtil.getHandle(repositoryUrl, this.taskId));
    }

    public String getTaskKey() {
        return this.taskId;
    }

    public boolean isSubmitting() {
        return this.submitting;
    }

    public void setSubmitting(boolean submitting) {
        this.submitting = submitting;
    }

    @Override
    public String toString() {
        return this.summary;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AbstractTask) {
            return this.getHandleIdentifier().equals(((AbstractTask)obj).getHandleIdentifier());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getHandleIdentifier().hashCode();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
        this.completionDate = completed ? new Date() : null;
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getNotes() {
        if (this.notes == null) {
            this.notes = "";
        }
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public int getEstimateTimeHours() {
        return this.estimatedTimeHours;
    }

    public void setEstimatedTimeHours(int estimated) {
        this.estimatedTimeHours = estimated;
    }

    public void addParentContainer(AbstractTaskContainer container) {
        this.containers.add(container);
    }

    public void removeParentContainer(AbstractTaskContainer container) {
        this.containers.remove(container);
    }

    public Set<AbstractTaskContainer> getParentContainers() {
        return new HashSet<AbstractTaskContainer>(this.containers);
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setScheduledForDate(Date date) {
        this.scheduledForDate = date;
    }

    public Date getScheduledForDate() {
        return this.scheduledForDate;
    }

    public boolean isReminded() {
        return this.reminded;
    }

    public void setReminded(boolean reminded) {
        this.reminded = reminded;
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            this.creationDate = new Date();
        }
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public boolean isPastReminder() {
        if (this.isCompleted() || this.scheduledForDate == null) {
            return false;
        }
        Date now = new Date();
        return this.scheduledForDate.compareTo(now) < 0;
    }

    public boolean hasValidUrl() {
        String taskUrl = this.getUrl();
        if (!(taskUrl == null || taskUrl.equals("") || taskUrl.equals("http://") || taskUrl.equals("https://"))) {
            try {
                new URL(taskUrl);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    public String getTaskKind() {
        return this.taskKind;
    }

    public void setTaskKind(String kind) {
        this.taskKind = kind;
    }

    @Override
    public int compareTo(AbstractTaskContainer taskListElement) {
        return this.summary.compareTo(((AbstractTask)taskListElement).summary);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date date) {
        this.dueDate = date;
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }

    public String getCategoryHandle() {
        return this.categoryHandle;
    }

    public void setCategoryHandle(String categoryHandle) {
        this.categoryHandle = categoryHandle;
    }

    public boolean internalIsFloatingScheduledDate() {
        return this.floatingScheduledDate;
    }

    public void internalSetFloatingScheduledDate(boolean floatingScheduledDate) {
        this.floatingScheduledDate = floatingScheduledDate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PriorityLevel {
        P1,
        P2,
        P3,
        P4,
        P5;


        public String toString() {
            switch (this) {
                case P1: {
                    return "P1";
                }
                case P2: {
                    return "P2";
                }
                case P3: {
                    return "P3";
                }
                case P4: {
                    return "P4";
                }
                case P5: {
                    return "P5";
                }
            }
            return "P3";
        }

        public String getDescription() {
            switch (this) {
                case P1: {
                    return "Very High";
                }
                case P2: {
                    return "High";
                }
                case P3: {
                    return "Normal";
                }
                case P4: {
                    return "Low";
                }
                case P5: {
                    return "Very Low";
                }
            }
            return "";
        }

        public static PriorityLevel fromLevel(int level) {
            if (level <= 1) {
                return P1;
            }
            if (level == 2) {
                return P2;
            }
            if (level == 3) {
                return P3;
            }
            if (level == 4) {
                return P4;
            }
            if (level >= 5) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel fromString(String string) {
            if (string.equals("P1")) {
                return P1;
            }
            if (string.equals("P2")) {
                return P2;
            }
            if (string.equals("P3")) {
                return P3;
            }
            if (string.equals("P4")) {
                return P4;
            }
            if (string.equals("P5")) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel fromDescription(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("Very High")) {
                return P1;
            }
            if (string.equals("High")) {
                return P2;
            }
            if (string.equals("Normal")) {
                return P3;
            }
            if (string.equals("Low")) {
                return P4;
            }
            if (string.equals("Very Low")) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel getDefault() {
            return P3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepositoryTaskSyncState {
        OUTGOING,
        SYNCHRONIZED,
        INCOMING,
        CONFLICT;

    }
}

