/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryTaskAttribute
implements Serializable {
    private static final long serialVersionUID = 5548885751645139746L;
    public static final String USER_OWNER = "task.common.user.owner";
    public static final String USER_CC = "task.common.user.cc";
    public static final String USER_REPORTER = "task.common.user.reporter";
    public static final String USER_REPORTER_NAME = "task.common.user.reporter.name";
    public static final String COMMENT_NEW = "task.common.comment.new";
    public static final String COMMENT_TEXT = "task.common.comment.text";
    public static final String COMMENT_DATE = "task.common.comment.date";
    public static final String COMMENT_AUTHOR = "task.common.comment.author";
    public static final String COMMENT_AUTHOR_NAME = "task.common.comment.author.name";
    public static final String DESCRIPTION = "task.common.description";
    public static final String ATTACHMENT_ID = "task.common.attachment.id";
    public static final String ATTACHMENT_TYPE = "task.common.attachment.type";
    public static final String ATTACHMENT_CTYPE = "task.common.attachment.ctype";
    public static final String ATTACHMENT_DATE = "task.common.attachment.date";
    public static final String ATTACHMENT_URL = "task.common.attachment.url";
    public static final String ATTACHMENT_FILENAME = "filename";
    public static final String ATTACHMENT_SIZE = "task.common.attachment.size";
    public static final String USER_ASSIGNED = "task.common.user.assigned";
    public static final String USER_ASSIGNED_NAME = "task.common.user.assigned.name";
    public static final String RESOLUTION = "task.common.resolution";
    public static final String STATUS = "task.common.status";
    public static final String PRIORITY = "task.common.priority";
    public static final String DATE_MODIFIED = "task.common.date.modified";
    public static final String SUMMARY = "task.common.summary";
    public static final String PRODUCT = "task.common.product";
    public static final String DATE_CREATION = "task.common.date.created";
    public static final String KEYWORDS = "task.common.keywords";
    public static final String ADD_SELF_CC = "task.common.addselfcc";
    public static final String NEW_CC = "task.common.newcc";
    public static final String REMOVE_CC = "task.common.removecc";
    public static final String TASK_KEY = "task.common.key";
    public static final String TRUE = "1";
    public static final String FALSE = "0";
    public static final String COMPONENT = "task.common.component";
    public static final String TYPE_SHORT_TEXT = "shortText";
    public static final String TYPE_LONG_TEXT = "longText";
    public static final String TYPE_DATE = "date";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_SINGLE_SELECT = "singleSelect";
    public static final String TYPE_MULTI_SELECT = "multiSelect";
    public static final String TYPE_PERSON = "person";
    public static final String TYPE_TASK_DEPENDENCY = "taskDepenedency";
    private boolean hidden = false;
    private boolean isReadOnly = false;
    private final String name;
    private final String id;
    private final Map<String, String> optionParameters;
    private final List<String> options;
    private final List<String> values = new ArrayList<String>();
    private final Map<String, String> metaData = new HashMap<String, String>();
    private transient RepositoryTaskData taskData;

    public RepositoryTaskAttribute(String id, String name, boolean hidden) {
        this.id = id;
        this.name = name;
        this.hidden = hidden;
        this.options = new ArrayList<String>();
        this.optionParameters = new HashMap<String, String>();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readonly) {
        this.isReadOnly = readonly;
    }

    public String getOptionParameter(String option) {
        return this.optionParameters.get(option);
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return "";
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValue(String value) {
        if (this.values.size() > 0) {
            this.values.set(0, value);
        } else {
            this.values.add(value);
        }
    }

    public void setValues(List<String> values) {
        this.values.clear();
        this.values.addAll(values);
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void removeValue(String value) {
        if (this.values.contains(value)) {
            this.values.remove(this.values.indexOf(value));
        }
    }

    public void clearValues() {
        this.values.clear();
    }

    public void addOption(String readableValue, String parameterValue) {
        this.options.add(readableValue);
        this.optionParameters.put(readableValue, parameterValue);
    }

    public boolean hasOptions() {
        return this.options.size() > 0;
    }

    public void clearOptions() {
        this.options.clear();
        this.optionParameters.clear();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean b) {
        this.hidden = b;
    }

    public String toString() {
        return String.valueOf(this.getId()) + ":" + this.values;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryTaskAttribute other = (RepositoryTaskAttribute)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void clearMetaData() {
        this.metaData.clear();
    }

    public void putMetaDataValue(String key, String value) {
        this.metaData.put(key, value);
    }

    public String getMetaDataValue(String key) {
        return this.metaData.get(key);
    }

    public void removeMetaDataValue(String key) {
        this.metaData.remove(key);
    }

    public Map<String, String> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    void setTaskData(RepositoryTaskData taskData) {
        this.taskData = taskData;
    }

    public RepositoryTaskData getTaskData() {
        return this.taskData;
    }
}

