/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoriesExternalizer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepositoryManager {
    public static final String OLD_REPOSITORIES_FILE = "repositories.xml";
    public static final String DEFAULT_REPOSITORIES_FILE = "repositories.xml.zip";
    public static final String PREF_REPOSITORIES = "org.eclipse.mylyn.tasklist.repositories.";
    private Map<String, AbstractRepositoryConnector> repositoryConnectors = new HashMap<String, AbstractRepositoryConnector>();
    private Map<String, Set<TaskRepository>> repositoryMap = new HashMap<String, Set<TaskRepository>>();
    private Set<ITaskRepositoryListener> listeners = new HashSet<ITaskRepositoryListener>();
    private Set<TaskRepository> orphanedRepositories = new HashSet<TaskRepository>();
    public static final String MESSAGE_NO_REPOSITORY = "No repository available, please add one using the Task Repositories view.";
    public static final String PREFIX_LOCAL = "local-";
    private TaskRepositoriesExternalizer externalizer = new TaskRepositoriesExternalizer();
    private TaskList taskList;

    public TaskRepositoryManager(TaskList taskList) {
        this.taskList = taskList;
    }

    public Collection<AbstractRepositoryConnector> getRepositoryConnectors() {
        return Collections.unmodifiableCollection(this.repositoryConnectors.values());
    }

    public AbstractRepositoryConnector getRepositoryConnector(String connectorKind) {
        return this.repositoryConnectors.get(connectorKind);
    }

    public AbstractRepositoryConnector getRepositoryConnector(AbstractTask task) {
        return this.getRepositoryConnector(task.getConnectorKind());
    }

    public void addRepositoryConnector(AbstractRepositoryConnector repositoryConnector) {
        if (!this.repositoryConnectors.values().contains(repositoryConnector)) {
            repositoryConnector.init(this.taskList);
            this.repositoryConnectors.put(repositoryConnector.getConnectorKind(), repositoryConnector);
        }
    }

    public boolean hasUserManagedRepositoryConnectors() {
        for (AbstractRepositoryConnector connector : this.repositoryConnectors.values()) {
            if (!connector.isUserManaged()) continue;
            return true;
        }
        return false;
    }

    public void addRepository(TaskRepository repository, String repositoryFilePath) {
        Set<Object> repositories;
        if (!this.repositoryMap.containsKey(repository.getConnectorKind())) {
            repositories = new HashSet();
            this.repositoryMap.put(repository.getConnectorKind(), repositories);
        } else {
            repositories = this.repositoryMap.get(repository.getConnectorKind());
        }
        repositories.add((Object)repository);
        this.saveRepositories(repositoryFilePath);
        this.taskList.addOrphanContainer(new UnmatchedTaskContainer(repository.getConnectorKind(), repository.getUrl()));
        for (ITaskRepositoryListener listener : this.listeners) {
            listener.repositoryAdded(repository);
        }
    }

    public void removeRepository(TaskRepository repository, String repositoryFilePath) {
        Set<TaskRepository> repositories = this.repositoryMap.get(repository.getConnectorKind());
        if (repositories != null) {
            repository.flushAuthenticationCredentials();
            repositories.remove((Object)repository);
            this.taskList.removeOrphanContainer(repository.getUrl());
        }
        this.saveRepositories(repositoryFilePath);
        for (ITaskRepositoryListener listener : this.listeners) {
            listener.repositoryRemoved(repository);
        }
    }

    public void addListener(ITaskRepositoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITaskRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public static String stripSlashes(String url) {
        StringBuilder sb = new StringBuilder(url.trim());
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '/') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public TaskRepository getRepository(String kind, String urlString) {
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        if (this.repositoryMap.containsKey(kind)) {
            for (TaskRepository repository : this.repositoryMap.get(kind)) {
                if (!TaskRepositoryManager.stripSlashes(repository.getUrl()).equals(urlString)) continue;
                return repository;
            }
        }
        return null;
    }

    public TaskRepository getRepository(String urlString) {
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        for (String kind : this.repositoryMap.keySet()) {
            for (TaskRepository repository : this.repositoryMap.get(kind)) {
                if (!TaskRepositoryManager.stripSlashes(repository.getUrl()).equals(urlString)) continue;
                return repository;
            }
        }
        return null;
    }

    public AbstractRepositoryConnector getConnectorForRepositoryTaskUrl(String url) {
        for (AbstractRepositoryConnector connector : this.getRepositoryConnectors()) {
            if (connector.getRepositoryUrlFromTaskUrl(url) == null) continue;
            for (TaskRepository repository : this.getRepositories(connector.getConnectorKind())) {
                if (!url.startsWith(repository.getUrl())) continue;
                return connector;
            }
        }
        return null;
    }

    public Set<TaskRepository> getRepositories(String kind) {
        if (this.repositoryMap.containsKey(kind)) {
            return this.repositoryMap.get(kind);
        }
        return Collections.emptySet();
    }

    public List<TaskRepository> getAllRepositories() {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
            if (!this.repositoryMap.containsKey(repositoryConnector.getConnectorKind())) continue;
            repositories.addAll((Collection<TaskRepository>)this.repositoryMap.get(repositoryConnector.getConnectorKind()));
        }
        return repositories;
    }

    public TaskRepository getRepositoryForActiveTask(String repositoryKind, TaskList taskList) {
        AbstractTask activeTask = taskList.getActiveTask();
        if (activeTask != null) {
            String repositoryUrl = activeTask.getRepositoryUrl();
            for (TaskRepository repository : this.getRepositories(repositoryKind)) {
                if (!repository.getUrl().equals(repositoryUrl)) continue;
                return repository;
            }
        }
        return null;
    }

    public TaskRepository getDefaultRepository(String kind) {
        if (this.repositoryMap.containsKey(kind)) {
            Iterator<TaskRepository> iterator = this.repositoryMap.get(kind).iterator();
            if (iterator.hasNext()) {
                TaskRepository repository = iterator.next();
                return repository;
            }
        } else {
            Collection<Set<TaskRepository>> values = this.repositoryMap.values();
            if (!values.isEmpty()) {
                Set<TaskRepository> repoistorySet = values.iterator().next();
                return repoistorySet.iterator().next();
            }
        }
        return null;
    }

    public Map<String, Set<TaskRepository>> readRepositories(String repositoriesFilePath) {
        this.repositoryMap.clear();
        this.orphanedRepositories.clear();
        this.loadRepositories(repositoriesFilePath);
        for (ITaskRepositoryListener listener : this.listeners) {
            try {
                listener.repositoriesRead();
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Repository listener failed", t));
            }
        }
        return this.repositoryMap;
    }

    private void loadRepositories(String repositoriesFilePath) {
        try {
            boolean migration = false;
            File repositoriesFile = new File(repositoriesFilePath);
            for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
                this.repositoryMap.put(repositoryConnector.getConnectorKind(), new HashSet());
            }
            if (repositoriesFile.exists()) {
                Set<TaskRepository> repositories = this.externalizer.readRepositoriesFromXML(repositoriesFile);
                if (repositories != null && repositories.size() > 0) {
                    for (TaskRepository repository : repositories) {
                        if (this.removeHttpAuthMigration(repository)) {
                            migration = true;
                        }
                        if (this.migrateAnonymousRepository(repository)) {
                            migration = true;
                        }
                        if (this.repositoryMap.containsKey(repository.getConnectorKind())) {
                            this.repositoryMap.get(repository.getConnectorKind()).add(repository);
                            continue;
                        }
                        this.orphanedRepositories.add(repository);
                    }
                }
                if (migration) {
                    this.saveRepositories(repositoriesFilePath);
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not load repositories", t));
        }
    }

    private boolean removeHttpAuthMigration(TaskRepository repository) {
        String httpusername = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.username");
        String httppassword = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.password");
        if (httpusername != null && httppassword != null) {
            repository.removeProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.username");
            repository.removeProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.password");
            if (httpusername.length() > 0 && httppassword.length() > 0) {
                repository.setHttpAuthenticationCredentials(httpusername, httppassword);
            }
            return true;
        }
        return false;
    }

    private boolean migrateAnonymousRepository(TaskRepository repository) {
        if (repository.getProperty("org.eclipse.mylyn.tasklist.repositories.anonymous") == null) {
            if (repository.getUserName() == null || repository.getPassword() == null || "".equals(repository.getUserName()) && "".equals(repository.getPassword())) {
                repository.setAnonymous(true);
            } else {
                repository.setAnonymous(false);
            }
            return true;
        }
        return false;
    }

    public void setVersion(TaskRepository repository, String version, String repositoriesFilePath) {
        repository.setVersion(version);
        this.saveRepositories(repositoriesFilePath);
    }

    public void setEncoding(TaskRepository repository, String encoding, String repositoriesFilePath) {
        repository.setCharacterEncoding(encoding);
        this.saveRepositories(repositoriesFilePath);
    }

    public void setTimeZoneId(TaskRepository repository, String timeZoneId, String repositoriesFilePath) {
        repository.setTimeZoneId(timeZoneId);
        this.saveRepositories(repositoriesFilePath);
    }

    public void setSynchronizationTime(TaskRepository repository, String syncTime, String repositoriesFilePath) {
        repository.setSynchronizationTimeStamp(syncTime);
        this.saveRepositories(repositoriesFilePath);
    }

    public synchronized boolean saveRepositories(String destinationPath) {
        if (!Platform.isRunning()) {
            return false;
        }
        HashSet<TaskRepository> repositoriesToWrite = new HashSet<TaskRepository>(this.getAllRepositories());
        for (TaskRepository repository : this.orphanedRepositories) {
            if (repositoriesToWrite.contains((Object)repository)) continue;
            repositoriesToWrite.add(repository);
        }
        try {
            File repositoriesFile = new File(destinationPath);
            this.externalizer.writeRepositoriesToXML(repositoriesToWrite, repositoriesFile);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not save repositories", t));
            return false;
        }
        return true;
    }

    public void clearRepositories(String repositoriesFilePath) {
        this.repositoryMap.clear();
        this.orphanedRepositories.clear();
        this.saveRepositories(repositoriesFilePath);
    }

    public void notifyRepositorySettingsChanged(TaskRepository repository) {
        for (ITaskRepositoryListener listener : this.listeners) {
            listener.repositorySettingsChanged(repository);
        }
    }

    public void insertRepositories(Set<TaskRepository> repositories, String repositoryFilePath) {
        for (TaskRepository repository : repositories) {
            if (this.getRepository(repository.getConnectorKind(), repository.getUrl()) != null) continue;
            this.addRepository(repository, repositoryFilePath);
        }
    }

    public boolean isOwnedByUser(AbstractTask task) {
        if (task.isLocal()) {
            return true;
        }
        AbstractTask repositoryTask = task;
        TaskRepository repository = this.getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
        if (repository != null && repositoryTask.getOwner() != null) {
            return repositoryTask.getOwner().equals(repository.getUserName());
        }
        return false;
    }
}

