/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Set;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public abstract class AbstractTaskListFilter {
    public abstract boolean select(Object var1, Object var2);

    public static boolean hasDescendantIncoming(AbstractTaskContainer container) {
        return AbstractTaskListFilter.hasDescendantIncoming(container, 10);
    }

    public static boolean hasIncompleteDescendant(AbstractTaskContainer container) {
        return AbstractTaskListFilter.hasIncompleteDescendant(container, 10);
    }

    private static boolean hasDescendantIncoming(AbstractTaskContainer container, int depth) {
        Set children = container.getChildren();
        if (children == null || depth <= 0) {
            return false;
        }
        for (AbstractTask task : children) {
            if (task == null) continue;
            AbstractTask containedRepositoryTask = task;
            if (containedRepositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING) {
                return true;
            }
            if (!TasksUiPlugin.getDefault().groupSubtasks(container) || !AbstractTaskListFilter.hasDescendantIncoming((AbstractTaskContainer)task, depth - 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasIncompleteDescendant(AbstractTaskContainer container, int depth) {
        Set children = container.getChildren();
        if (children == null || depth <= 0) {
            return false;
        }
        for (AbstractTask task : children) {
            if (task == null) continue;
            AbstractTask containedRepositoryTask = task;
            if (!containedRepositoryTask.isCompleted()) {
                return true;
            }
            if (!AbstractTaskListFilter.hasIncompleteDescendant((AbstractTaskContainer)task, depth - 1)) continue;
            return true;
        }
        return false;
    }
}

