/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewCategoryAction;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveToCategoryMenuContributor
implements IDynamicSubMenuContributor {
    private static final String LABEL = "Move to";

    @Override
    public MenuManager getSubMenuManager(final List<AbstractTaskContainer> selectedElements) {
        MenuManager subMenuManager = new MenuManager(LABEL);
        subMenuManager.setVisible(selectedElements.size() > 0 && selectedElements.get(0) instanceof AbstractTask);
        ArrayList categories = new ArrayList(TasksUiPlugin.getTaskListManager().getTaskList().getCategories());
        Collections.sort(categories);
        for (final AbstractTaskCategory category : categories) {
            if (category instanceof UnmatchedTaskContainer) continue;
            Action action = new Action(){

                public void run() {
                    MoveToCategoryMenuContributor.this.moveToCategory(selectedElements, category);
                }
            };
            String text = this.handleAcceleratorKeys(category.getSummary());
            action.setText(text);
            action.setImageDescriptor(TasksUiImages.CATEGORY);
            subMenuManager.add((IAction)action);
        }
        NewCategoryAction action = new NewCategoryAction(){

            public void run() {
                super.run();
                if (this.cat != null) {
                    MoveToCategoryMenuContributor.this.moveToCategory(selectedElements, (AbstractTaskCategory)this.cat);
                }
            }
        };
        subMenuManager.add((IContributionItem)new Separator());
        subMenuManager.add((IAction)action);
        return subMenuManager;
    }

    public String handleAcceleratorKeys(String text) {
        if (text == null) {
            return null;
        }
        int index = text.lastIndexOf(9);
        if (index == -1) {
            index = text.lastIndexOf(64);
        }
        if (index >= 0) {
            return text.concat("@");
        }
        return text;
    }

    private void moveToCategory(List<AbstractTaskContainer> selectedElements, AbstractTaskCategory category) {
        for (AbstractTaskContainer element : selectedElements) {
            if (!(element instanceof AbstractTask)) continue;
            TasksUiPlugin.getTaskListManager().getTaskList().moveTask((AbstractTask)element, (AbstractTaskContainer)category);
        }
    }
}

