/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.internal.monitor.core.util.IStatusHandler;
import org.eclipse.mylyn.internal.tasks.ui.util.WebBrowserDialog;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RepositoryAwareStatusHandler
implements IStatusHandler {
    private static boolean errorDialogOpen = false;
    protected static final String ERROR_MESSAGE = "Please report the following error at:\nhttp://bugs.eclipse.org/bugs/enter_bug.cgi?product=Mylyn\n\nOr via the popup menu in the Error Log view (see Window -> Show View)";

    public void fail(final IStatus status, boolean informUser) {
        if (informUser && Platform.isRunning()) {
            try {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Shell shell = null;
                        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        }
                        Shell shell2 = shell;
                        synchronized (shell2) {
                            try {
                                if (!errorDialogOpen) {
                                    errorDialogOpen = true;
                                    ErrorDialog.openError((Shell)shell, (String)"Mylyn Error", (String)RepositoryAwareStatusHandler.ERROR_MESSAGE, (IStatus)status);
                                }
                            }
                            finally {
                                errorDialogOpen = false;
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                status.getException().printStackTrace();
            }
        }
    }

    public void displayStatus(final String title, final IStatus status) {
        if (status.getCode() == 7) {
            StatusHandler.log((IStatus)status);
            this.fail(status, true);
            return;
        }
        if (Platform.isRunning()) {
            try {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = null;
                        if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
                            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        }
                        if (status instanceof RepositoryStatus && ((RepositoryStatus)status).isHtmlMessage()) {
                            WebBrowserDialog.openAcceptAgreement(shell, title, status.getMessage(), ((RepositoryStatus)status).getHtmlMessage());
                            return;
                        }
                        switch (status.getSeverity()) {
                            case 1: 
                            case 8: {
                                RepositoryAwareStatusHandler.this.createDialog(shell, title, status.getMessage(), 2).open();
                                break;
                            }
                            case 2: {
                                RepositoryAwareStatusHandler.this.createDialog(shell, title, status.getMessage(), 4).open();
                                break;
                            }
                            default: {
                                RepositoryAwareStatusHandler.this.createDialog(shell, title, status.getMessage(), 1).open();
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                status.getException().printStackTrace();
            }
        }
    }

    private MessageDialog createDialog(Shell shell, String title, String message, int type) {
        return new MessageDialog(shell, title, null, message, type, new String[]{IDialogConstants.OK_LABEL}, 0);
    }
}

