/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class SubmitTaskDataJob
extends Job {
    private static final String LABEL_JOB_SUBMIT = "Submitting to repository";
    private final TaskRepository taskRepository;
    private final RepositoryTaskData taskData;
    private final AbstractRepositoryConnector connector;
    private boolean attachContext;
    private IStatus errorStatus;
    private AbstractTask task;

    public SubmitTaskDataJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, RepositoryTaskData taskData) {
        super(LABEL_JOB_SUBMIT);
        this.connector = connector;
        this.taskRepository = taskRepository;
        this.taskData = taskData;
    }

    public boolean getAttachContext() {
        return this.attachContext;
    }

    public void setAttachContext(boolean attachContext) {
        this.attachContext = attachContext;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Submitting task", 3);
            String taskId = this.connector.getTaskDataHandler().postTaskData(this.taskRepository, this.taskData, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.taskData.isNew()) {
                if (taskId == null) {
                    throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 7, "Task could not be created. No additional information was provided by the connector."));
                }
                this.task = this.connector.createTaskFromExistingId(this.taskRepository, taskId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.task == null) {
                    throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 7, "Task could not be created. No additional information was provided by the connector."));
                }
            } else {
                this.task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.taskRepository.getUrl(), this.taskData.getId());
            }
            if (this.task == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            try {
                if (this.attachContext && this.connector.getAttachmentHandler() != null) {
                    this.connector.getAttachmentHandler().attachContext(this.taskRepository, this.task, "", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                TasksUiPlugin.getSynchronizationScheduler().synchNow(0L, Collections.singletonList(this.taskRepository), false);
                this.task.setSubmitting(true);
                try {
                    Job synchronizeJob = TasksUiPlugin.getSynchronizationManager().synchronize(this.connector, this.task, true, null);
                    synchronizeJob.join();
                }
                finally {
                    this.task.setSubmitting(false);
                }
                TasksUiPlugin.getSynchronizationManager().setTaskRead(this.task, true);
            }
            catch (CoreException e) {
                this.errorStatus = e.getStatus();
            }
            catch (Exception e) {
                this.errorStatus = new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public IStatus getError() {
        return this.errorStatus;
    }

    public AbstractTask getTask() {
        return this.task;
    }
}

