/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TaskListHyperlink
extends ImageHyperlink {
    private final MouseTrackListener MOUSE_TRACK_LISTENER = new MouseTrackListener(){

        public void mouseEnter(MouseEvent e) {
            TaskListHyperlink.this.setUnderlined(true);
        }

        public void mouseExit(MouseEvent e) {
            TaskListHyperlink.this.setUnderlined(false);
        }

        public void mouseHover(MouseEvent e) {
        }
    };
    private boolean strikeThrough;
    private AbstractTask task;

    public TaskListHyperlink(Composite parent, int style) {
        super(parent, style);
        this.setForeground(TaskListColorsAndFonts.COLOR_HYPERLINK_WIDGET);
        this.addMouseTrackListener(this.MOUSE_TRACK_LISTENER);
    }

    public void dispose() {
        this.removeMouseTrackListener(this.MOUSE_TRACK_LISTENER);
        super.dispose();
    }

    public AbstractTask getTask() {
        return this.task;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    protected void paintText(GC gc, Rectangle bounds) {
        super.paintText(gc, bounds);
        if (this.strikeThrough) {
            Point totalSize = this.computeTextSize(-1, -1);
            int textWidth = Math.min(bounds.width, totalSize.x);
            int textHeight = totalSize.y;
            int lineY = bounds.y + textHeight / 2;
            gc.drawLine(bounds.x, lineY, bounds.x + textWidth, lineY);
        }
    }

    public void setStrikeThrough(boolean strikethrough) {
        this.strikeThrough = strikethrough;
    }

    public void setTask(AbstractTask task) {
        this.task = task;
        if (task != null) {
            if ((this.getStyle() & 0x8000) != 0) {
                this.setText(task.getTaskKey());
                this.setToolTipText(String.valueOf(task.getTaskKey()) + ": " + task.getSummary());
                this.setStrikeThrough(task.isCompleted());
            } else {
                this.setText(task.getSummary());
                this.setToolTipText("");
                this.setStrikeThrough(false);
            }
        } else {
            this.setText("");
            this.setToolTipText("");
            this.setStrikeThrough(false);
        }
        this.setUnderlined(false);
    }

    protected String shortenText(GC gc, String t, int width) {
        if (t == null) {
            return null;
        }
        if ((this.getStyle() & 0x8000) != 0) {
            return t;
        }
        String returnText = t;
        if (gc.textExtent((String)t).x > width) {
            int i = t.length();
            while (i > 0) {
                String test = t.substring(0, i);
                test = String.valueOf(test) + "...";
                if (gc.textExtent((String)test).x < width) {
                    returnText = test;
                    break;
                }
                --i;
            }
        }
        return returnText;
    }
}

