/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.notifications.AbstractNotification;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotificationPopup;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListNotificationManager
implements IPropertyChangeListener {
    private static final String OPEN_NOTIFICATION_JOB = "Open Notification Job";
    private static final long DELAY_OPEN = 5000L;
    private static final boolean runSystem = true;
    private TaskListNotificationPopup popup;
    private Set<AbstractNotification> notifications = new HashSet<AbstractNotification>();
    private Set<AbstractNotification> currentlyNotifying = Collections.synchronizedSet(this.notifications);
    private List<ITaskListNotificationProvider> notificationProviders = new ArrayList<ITaskListNotificationProvider>();
    private Job openJob = new Job("Open Notification Job"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            TaskListNotificationManager.this.collectNotifications();
                            Class<TaskListNotificationManager> clazz = TaskListNotificationManager.class;
                            synchronized (TaskListNotificationManager.class) {
                                if (TaskListNotificationManager.this.currentlyNotifying.size() > 0) {
                                    TaskListNotificationManager.this.showPopup();
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
            }
            finally {
                if (TaskListNotificationManager.this.popup != null) {
                    this.schedule(TaskListNotificationManager.this.popup.getDelayClose() / 2L);
                } else {
                    this.schedule(5000L);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };

    public void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.popup = new TaskListNotificationPopup(shell);
        this.popup.setFadingEnabled(TasksUiUtil.isAnimationsEnabled());
        ArrayList<AbstractNotification> toDisplay = new ArrayList<AbstractNotification>(this.currentlyNotifying);
        Collections.sort(toDisplay);
        this.popup.setContents(toDisplay);
        this.cleanNotified();
        this.popup.setBlockOnOpen(false);
        this.popup.open();
    }

    private void cleanNotified() {
        this.currentlyNotifying.clear();
    }

    public void collectNotifications() {
        for (ITaskListNotificationProvider provider : this.notificationProviders) {
            this.currentlyNotifying.addAll(provider.getNotifications());
        }
    }

    public void startNotification(long initialStartupTime) {
        if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled")) {
            if (!this.openJob.cancel()) {
                try {
                    this.openJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.openJob.setSystem(true);
            this.openJob.schedule(initialStartupTime);
        }
    }

    public void stopNotification() {
        this.openJob.cancel();
    }

    public void addNotificationProvider(ITaskListNotificationProvider notification_provider) {
        this.notificationProviders.add(notification_provider);
    }

    public void removeNotificationProvider(ITaskListNotificationProvider notification_provider) {
        this.notificationProviders.remove(notification_provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractNotification> getNotifications() {
        Class<TaskListNotificationManager> clazz = TaskListNotificationManager.class;
        synchronized (TaskListNotificationManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentlyNotifying;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.notifications.enabled")) {
            Object newValue = event.getNewValue();
            if (!(newValue instanceof Boolean)) {
                this.startNotification(0L);
            } else if (((Boolean)newValue).booleanValue()) {
                this.startNotification(0L);
            } else {
                this.stopNotification();
            }
        }
    }
}

