/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CloneTaskAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private static final String LABEL = "Clone This Task";
    private static final String ID = "org.eclipse.mylyn.tasklist.actions.clone";
    protected ISelection selection;

    public CloneTaskAction() {
        super(LABEL);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
        this.setAccelerator(SWT.MOD1 + 100);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            super.selectionChanged((IStructuredSelection)selection);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        try {
            for (Object selectedObject : this.getStructuredSelection().toList()) {
                TaskSelection taskSelection;
                if (!(selectedObject instanceof AbstractTask)) continue;
                AbstractTask task = (AbstractTask)selectedObject;
                String description = "Cloned from: " + CopyTaskDetailsAction.getTextForTask(task);
                RepositoryTaskData taskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
                if (taskData != null) {
                    taskSelection = new TaskSelection(taskData);
                    taskSelection.getTaskData().setDescription(String.valueOf(description) + "\n\n> " + taskData.getDescription());
                } else {
                    taskSelection = new TaskSelection(task);
                    if (task instanceof LocalTask) {
                        String notes = task.getNotes();
                        if (!"".equals(notes)) {
                            taskSelection.getTaskData().setDescription(String.valueOf(description) + "\n\n" + notes);
                        } else {
                            taskSelection.getTaskData().setDescription(description);
                        }
                    } else {
                        taskSelection.getTaskData().setDescription(description);
                    }
                }
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (TasksUiUtil.openNewTaskEditor(shell, taskSelection, null)) continue;
                return;
            }
        }
        catch (NullPointerException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not remove task from category, it may still be refreshing.", (Throwable)e));
        }
    }

    public void init(IViewPart view) {
    }
}

