/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class DeleteAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.delete";

    public DeleteAction() {
        this.setText("Delete");
        this.setId(ID);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_TOOL_DELETE"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void run() {
        Object object;
        ISelection selection = TaskListView.getFromActivePerspective().getViewer().getSelection();
        List toDelete = ((IStructuredSelection)selection).toList();
        String elements = "";
        int i = 0;
        for (Object object2 : toDelete) {
            if (object2 instanceof UnmatchedTaskContainer) continue;
            if (++i < 20) {
                if (!(object2 instanceof AbstractTaskContainer)) continue;
                elements = String.valueOf(elements) + "    " + ((AbstractTaskContainer)object2).getSummary() + "\n";
                continue;
            }
            elements = String.valueOf(elements) + "...";
            break;
        }
        String message = toDelete.size() == 1 ? ((object = toDelete.get(0)) instanceof AbstractTask ? (((AbstractTask)object).isLocal() ? "Permanently delete the task listed below?" : "Delete the planning information and context for the repository task?  The server copy will not be deleted and the task will remain in queries that match it.") : (object instanceof TaskCategory ? "Permanently delete the category?  Local tasks will be moved to the Uncategorized folder. Repository tasks will be moved to the Unmatched folder." : (object instanceof AbstractRepositoryQuery ? "Permanently delete the query?  Contained tasks will be moved to the Unmatched folder." : "Permanently delete the element listed below?"))) : "Delete the elements listed below?  If categories or queries are selected contained tasks will not be deleted.  Contexts will be deleted for selected tasks.";
        message = String.valueOf(message) + "\n\n" + elements;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Confirm Delete", (String)message);
        if (!deleteConfirmed) {
            return;
        }
        for (Object selectedObject : toDelete) {
            if (selectedObject instanceof AbstractTask) {
                AbstractTask task = null;
                task = (AbstractTask)selectedObject;
                TasksUiPlugin.getTaskListManager().deactivateTask(task);
                TasksUiPlugin.getTaskListManager().getTaskList().deleteTask(task);
                ContextCorePlugin.getContextManager().deleteContext(task.getHandleIdentifier());
                TasksUiUtil.closeEditorInActivePage(task, false);
                continue;
            }
            if (selectedObject instanceof AbstractRepositoryQuery) {
                TasksUiPlugin.getTaskListManager().getTaskList().deleteQuery((AbstractRepositoryQuery)selectedObject);
                continue;
            }
            if (selectedObject instanceof TaskCategory) {
                TaskCategory cat = (TaskCategory)selectedObject;
                for (AbstractTask task : cat.getChildren()) {
                    ContextCorePlugin.getContextManager().deleteContext(task.getHandleIdentifier());
                    TasksUiUtil.closeEditorInActivePage(task, false);
                }
                TasksUiPlugin.getTaskListManager().getTaskList().deleteCategory((AbstractTaskCategory)cat);
                continue;
            }
            if (selectedObject instanceof UnmatchedTaskContainer) continue;
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete failed", (String)"Nothing selected.");
            return;
        }
    }
}

