/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.ui.util.TreeWalker;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class GoToUnreadTaskAction
extends Action
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String ID_NEXT = "org.eclipse.mylyn.tasklist.actions.goToNextUnread";
    public static final String ID_PREVIOUS = "org.eclipse.mylyn.tasklist.actions.goToPreviousUnread";
    private TaskListView taskListView;
    private TreeWalker.Direction direction = TreeWalker.Direction.DOWN;

    public void dispose() {
    }

    public TreeWalker.Direction getDirection() {
        return this.direction;
    }

    private TreePath getUnreadItem(TreeViewer treeViewer, Tree tree) {
        TreeItem[] selection = tree.getSelection();
        TreeItem selectedItem = selection.length > 0 ? selection[0] : null;
        TreeWalker.TreeVisitor visitor = new TreeWalker.TreeVisitor(){

            public boolean visit(Object object) {
                AbstractTask task;
                return object instanceof AbstractTask && (task = (AbstractTask)object).getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING;
            }
        };
        TreeWalker treeWalker = new TreeWalker(treeViewer);
        treeWalker.setDirection(this.direction);
        treeWalker.setExpandNodes(true);
        return treeWalker.walk(visitor, selectedItem);
    }

    public void init(IViewPart view) {
        this.taskListView = (TaskListView)view;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        TreeViewer treeViewer;
        if (this.taskListView == null) {
            TaskListView activeTaskListView = TaskListView.getFromActivePerspective();
            if (activeTaskListView == null) {
                return;
            }
            treeViewer = activeTaskListView.getViewer();
        } else {
            treeViewer = this.taskListView.getViewer();
        }
        Tree tree = treeViewer.getTree();
        TreePath treePath = null;
        try {
            tree.setRedraw(false);
            treePath = this.getUnreadItem(treeViewer, tree);
        }
        finally {
            tree.setRedraw(true);
        }
        if (treePath != null) {
            treeViewer.expandToLevel((Object)treePath, 0);
            treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
        }
    }

    public void run(IAction action) {
        if (ID_PREVIOUS.equals(action.getId())) {
            this.setDirection(TreeWalker.Direction.UP);
        } else {
            this.setDirection(TreeWalker.Direction.DOWN);
        }
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setDirection(TreeWalker.Direction direction) {
        this.direction = direction;
    }
}

