/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImportAction
extends Action
implements IViewActionDelegate {
    protected ISelection selection;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void run() {
        File file;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell);
        dialog.setFilterExtensions(new String[]{"*.xml.zip"});
        String path = dialog.open();
        if (path != null && (file = new File(path)).isFile()) {
            try {
                List<AbstractRepositoryQuery> queries = TasksUiPlugin.getTaskListManager().getTaskListWriter().readQueries(file);
                Set<TaskRepository> repositories = TasksUiPlugin.getTaskListManager().getTaskListWriter().readRepositories(file);
                if (queries.size() > 0) {
                    this.importQueries(queries, repositories, shell);
                } else {
                    MessageDialog.openError((Shell)shell, (String)"Query Import Error", (String)"The specified file is not an exported query. Please, check that you have provided the correct file.");
                }
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)shell, (String)"Query Import Error", (String)"The specified file is not an exported query. Please, check that you have provided the correct file.");
            }
        }
    }

    public void importQueries(List<AbstractRepositoryQuery> queries, Set<TaskRepository> repositories, Shell shell) {
        TasksUiPlugin.getRepositoryManager().insertRepositories(repositories, TasksUiPlugin.getDefault().getRepositoriesFilePath());
        List<AbstractRepositoryQuery> badQueries = TasksUiPlugin.getTaskListManager().insertQueries(queries);
        String message = "The following queries were imported successfully: ";
        for (AbstractRepositoryQuery imported : queries) {
            if (badQueries.contains(imported)) continue;
            message = String.valueOf(message) + "\n" + imported.getHandleIdentifier();
        }
        if (badQueries.size() > 0) {
            message = String.valueOf(message) + "\n\n These queries were not imported, since their repository was not found: ";
            for (AbstractRepositoryQuery bad : badQueries) {
                message = String.valueOf(message) + "\n" + bad.getHandleIdentifier();
            }
        }
        MessageDialog.openInformation((Shell)shell, (String)"Query Import Completed", (String)message);
    }
}

