/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class RemoveFromCategoryAction
extends Action {
    private static final String LABEL = "Remove From Category";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.remove";
    private final TaskListView view;

    public RemoveFromCategoryAction(TaskListView view) {
        this.view = view;
        this.setText(LABEL);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.REMOVE);
    }

    public void run() {
        try {
            ISelection selection = TaskListView.getFromActivePerspective().getViewer().getSelection();
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                if (!(selectedObject instanceof AbstractTask)) continue;
                AbstractTask task = (AbstractTask)selectedObject;
                if (task.isActive()) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"Task must be deactivated in order to remove from category.");
                    return;
                }
                TreeItem item = this.view.getViewer().getTree().getSelection()[0];
                Set parentContainers = task.getParentContainers();
                if (item.getParentItem() != null && item.getParent().getData() instanceof TaskCategory) {
                    TaskCategory category = (TaskCategory)item.getParentItem().getData();
                    TasksUiPlugin.getTaskListManager().getTaskList().removeFromCategory(category, task);
                    continue;
                }
                if (!parentContainers.isEmpty() && TaskCategory.getParentTaskCategory((AbstractTask)task) != null) {
                    TasksUiPlugin.getTaskListManager().getTaskList().removeFromCategory(TaskCategory.getParentTaskCategory((AbstractTask)task), task);
                    continue;
                }
                if (!task.isLocal()) {
                    TasksUiPlugin.getTaskListManager().getTaskList().moveTask(task, null);
                    continue;
                }
                TasksUiPlugin.getTaskListManager().getTaskList().moveTask(task, (AbstractTaskContainer)TasksUiPlugin.getTaskListManager().getTaskList().getDefaultCategory());
            }
        }
        catch (NullPointerException e) {
            StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not remove task from category, it may still be refreshing.", (Throwable)e));
        }
    }
}

