/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class TaskDeactivateAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.context.deactivate";

    public TaskDeactivateAction() {
        this.setId(ID);
        this.setText("Deactivate");
        this.setImageDescriptor(TasksUiImages.TASK_INACTIVE);
    }

    public void run(AbstractTask task) {
        try {
            if (task != null) {
                TasksUiPlugin.getTaskListManager().deactivateTask(task);
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Closing task editor on task deactivation failed", (Throwable)e));
        }
    }

    public void run() {
        this.run(TaskListView.getFromActivePerspective().getSelectedTask());
    }
}

