/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.internal.tasks.core.ITaskRepositoryFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTaskSelectionDialog
extends SelectionStatusDialog {
    private Text idText;
    private TableViewer tasksViewer;
    private ComboViewer repositoriesViewer;
    private Button addToTaskListCheck;
    private ComboViewer categoryViewer;
    private String[] selectedIds;
    private TaskRepository selectedRepository;
    private AbstractTask selectedTask;
    private boolean shouldAddToTaskList;
    private AbstractTaskCategory selectedCategory;

    public RemoteTaskSelectionDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
    }

    private List<TaskRepository> getTaskRepositories() {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        for (AbstractRepositoryConnector connector : repositoryManager.getRepositoryConnectors()) {
            Set connectorRepositories = repositoryManager.getRepositories(connector.getConnectorKind());
            for (TaskRepository repository : connectorRepositories) {
                if (!ITaskRepositoryFilter.CAN_CREATE_TASK_FROM_KEY.accept(repository, connector)) continue;
                repositories.add(repository);
            }
        }
        return repositories;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Label idLabel = new Label(area, 0);
        idLabel.setText("Enter Key/&ID (use comma for multiple): ");
        this.idText = new Text(area, 2048);
        this.idText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label matchingTasksLabel = new Label(area, 0);
        matchingTasksLabel.setText("&Matching tasks:");
        this.tasksViewer = new TableViewer(area, 2820);
        this.tasksViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(400, 200).create());
        this.tasksViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskElementLabelProvider(true), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.tasksViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tasksViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (RemoteTaskSelectionDialog.this.selectedIds == null) {
                    return false;
                }
                if (!(element instanceof AbstractTask)) {
                    return false;
                }
                AbstractTask task = (AbstractTask)element;
                String taskId = task.getTaskKey();
                String[] stringArray = RemoteTaskSelectionDialog.this.selectedIds;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (id.equals(taskId)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        this.tasksViewer.setInput((Object)TasksUiPlugin.getTaskListManager().getTaskList().getAllTasks());
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteTaskSelectionDialog.this.computeIds();
                RemoteTaskSelectionDialog.this.validate();
                RemoteTaskSelectionDialog.this.tasksViewer.refresh(false);
            }
        });
        this.tasksViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemoteTaskSelectionDialog.this.validate();
            }
        });
        this.tasksViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (RemoteTaskSelectionDialog.this.getOkButton().getEnabled()) {
                    RemoteTaskSelectionDialog.this.okPressed();
                }
            }
        });
        Table table = this.tasksViewer.getTable();
        table.showSelection();
        Composite repositoriesComposite = new Composite(area, 0);
        repositoriesComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        repositoriesComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        Label repositoriesLabel = new Label(repositoriesComposite, 0);
        repositoriesLabel.setText("&Select a task repository:");
        this.repositoriesViewer = new ComboViewer(repositoriesComposite, 12);
        this.repositoriesViewer.setLabelProvider((IBaseLabelProvider)new TaskRepositoryLabelProvider());
        this.repositoriesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.repositoriesViewer.setInput(this.getTaskRepositories());
        TaskRepository currentRepository = TasksUiUtil.getSelectedRepository(null);
        if (currentRepository != null) {
            this.repositoriesViewer.setSelection((ISelection)new StructuredSelection((Object)currentRepository), true);
        }
        this.repositoriesViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.repositoriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RemoteTaskSelectionDialog.this.tasksViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                RemoteTaskSelectionDialog.this.validate();
            }
        });
        Button addRepositoryButton = new Button(repositoriesComposite, 0);
        addRepositoryButton.setText("&Add...");
        addRepositoryButton.setEnabled(TasksUiPlugin.getRepositoryManager().hasUserManagedRepositoryConnectors());
        addRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IHandlerService hndSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    hndSvc.executeCommand("org.eclipse.mylyn.tasks.ui.command.addTaskRepository", null);
                    RemoteTaskSelectionDialog.this.repositoriesViewer.setInput((Object)RemoteTaskSelectionDialog.this.getTaskRepositories());
                }
                catch (CommandException e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", e.getMessage(), (Throwable)e));
                }
            }
        });
        Composite addToTaskListComposite = new Composite(area, 0);
        addToTaskListComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.addToTaskListCheck = new Button(addToTaskListComposite, 32);
        this.addToTaskListCheck.setText("Add to Task &List category:");
        this.categoryViewer = new ComboViewer(addToTaskListComposite, 12);
        this.categoryViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
        LinkedList<AbstractTaskCategory> categories = new LinkedList<AbstractTaskCategory>(taskList.getCategories());
        categories.addFirst(taskList.getDefaultCategory());
        this.categoryViewer.setInput(categories);
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractTaskContainer) {
                    return ((AbstractTaskContainer)element).getSummary();
                }
                return super.getText(element);
            }
        });
        this.categoryViewer.setSelection((ISelection)new StructuredSelection((Object)taskList.getDefaultCategory()));
        this.categoryViewer.getControl().setEnabled(this.addToTaskListCheck.getSelection());
        this.addToTaskListCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteTaskSelectionDialog.this.categoryViewer.getControl().setEnabled(RemoteTaskSelectionDialog.this.addToTaskListCheck.getSelection());
            }
        });
        this.idText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    RemoteTaskSelectionDialog.this.tasksViewer.getControl().setFocus();
                }
            }
        });
        return area;
    }

    private void validate() {
        if (this.idText.getText().trim().equals("")) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", 0, "Enter a valid task ID", null));
            return;
        }
        if (this.tasksViewer.getSelection().isEmpty() && this.repositoriesViewer.getSelection().isEmpty()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", 0, "Select a task or repository", null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.mylyn.tasks.ui", 0, "", null));
    }

    public String[] getSelectedIds() {
        return this.selectedIds;
    }

    public TaskRepository getSelectedTaskRepository() {
        return this.selectedRepository;
    }

    public AbstractTask getSelectedTask() {
        return this.selectedTask;
    }

    public boolean shouldAddToTaskList() {
        return this.shouldAddToTaskList;
    }

    public AbstractTaskCategory getSelectedCategory() {
        return this.selectedCategory;
    }

    protected void computeResult() {
        this.computeIds();
        ISelection taskSelection = this.tasksViewer.getSelection();
        if (!taskSelection.isEmpty()) {
            this.selectedTask = (AbstractTask)((IStructuredSelection)taskSelection).getFirstElement();
        } else {
            this.selectedRepository = (TaskRepository)((IStructuredSelection)this.repositoriesViewer.getSelection()).getFirstElement();
        }
        this.shouldAddToTaskList = this.addToTaskListCheck.getSelection();
        if (this.shouldAddToTaskList) {
            this.selectedCategory = (AbstractTaskCategory)((IStructuredSelection)this.categoryViewer.getSelection()).getFirstElement();
        }
    }

    private void computeIds() {
        String[] stringArray = this.selectedIds = this.idText.getText().split(",");
        int n = this.selectedIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            String string = id.trim();
            ++n2;
        }
    }
}

