/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.tasks.core.AbstractAttributeMapper;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttributeManager;
import org.eclipse.mylyn.internal.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractAttributeEditor {
    protected static final int MAXIMUM_HEIGHT = 140;
    protected static final int MAXIMUM_WIDTH = 500;
    protected static final Font TEXT_FONT = JFaceResources.getDefaultFont();
    private Control control;
    private boolean decorationEnabled;
    private Label labelControl;
    private LayoutHint layoutHint;
    private final AttributeManager manager;
    private final RepositoryTaskAttribute taskAttribute;

    public AbstractAttributeEditor(AttributeManager manager, RepositoryTaskAttribute taskAttribute) {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)taskAttribute);
        this.manager = manager;
        this.taskAttribute = taskAttribute;
    }

    protected void attributeChanged() {
        this.getAttributeEditorManager().attributeChanged(this.getTaskAttribute());
    }

    public abstract void createControl(Composite var1, FormToolkit var2);

    public void createLabelControl(Composite composite, FormToolkit toolkit) {
        this.labelControl = this.manager.hasOutgoingChanges(this.getTaskAttribute()) ? toolkit.createLabel(composite, "*" + this.getLabel()) : toolkit.createLabel(composite, this.getLabel());
        this.labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
    }

    public void dispose() {
    }

    public AttributeManager getAttributeEditorManager() {
        return this.manager;
    }

    protected AbstractAttributeMapper getAttributeMapper() {
        return this.getTaskAttribute().getTaskData().getAttributeFactory().getAttributeMapper();
    }

    public Control getControl() {
        return this.control;
    }

    public String getLabel() {
        return this.getAttributeMapper().getLabel(this.getTaskAttribute());
    }

    public Label getLabelControl() {
        return this.labelControl;
    }

    public LayoutHint getLayoutHint() {
        return this.layoutHint;
    }

    public RepositoryTaskAttribute getTaskAttribute() {
        return this.taskAttribute;
    }

    public boolean hasLabel() {
        return true;
    }

    public boolean isDecorationEnabled() {
        return this.decorationEnabled;
    }

    protected void setControl(Control control) {
        this.control = control;
    }

    public void setDecorationEnabled(boolean decorationEnabled) {
        this.decorationEnabled = decorationEnabled;
    }

    protected void setLayoutHint(LayoutHint layoutHint) {
        this.layoutHint = layoutHint;
    }

    public void decorate(Color color) {
        if (this.isDecorationEnabled()) {
            this.getControl().setBackground(color);
        }
    }
}

